/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;

public class VTTSampleDescription
extends SampleDescription {
    @Override
    public void parseSampleDescription(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        if (!"wvtt".equals(this.dataFormat) && !"svtt".equals(this.dataFormat)) {
            return;
        }
        super.parseSampleDescription(ctx, quickTimeParser, movieFile);
    }

    @Override
    public List<KeyValuePair> getProperties() {
        return super.getProperties();
    }

    @Override
    public SampleDescription.SampleDescriptionExtension createSampleDescriptionExtension(String extensionType, long sdeSize, long sdeOffset) {
        SampleDescription.SampleDescriptionExtension extension = new SampleDescription.SampleDescriptionExtension();
        if (extensionType.equals("vttC")) {
            extension = new vttCSampleDescriptionExtension();
        } else if (extensionType.equals("vlab")) {
            extension = new vlabSampleDescriptionExtension();
        } else if (extensionType.equals("rqdf")) {
            extension = new rqdfSampleDescriptionExtension();
        } else if (extensionType.equals("vttR")) {
            extension = new vttRSampleDescriptionExtension();
        }
        extension.setAttributes(sdeOffset, sdeSize, extensionType);
        return extension;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private static String readStringBytes(SeekableDataInput input, int len) throws IOException {
        byte[] stringBytes = new byte[len];
        input.readFully(stringBytes);
        return new String(stringBytes, 0, len, "ASCII");
    }

    public class vttRSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        List<vttResourcePayload> _payloads = Lists.newArrayList();

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            int totalResourceLen = (int)this.getAtomSize() - 8;
            if (totalResourceLen <= 8) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "We were expecting a list of 'rsrc' but there is not enough space for the atom: totalLen:" + String.valueOf(totalResourceLen), movieFile.getFilePointer() - 1L);
            }
            while (totalResourceLen > 8) {
                int rsrcLen = (int)BitstreamReader.readU32((DataInput)movieFile);
                String rsrcTag = BitstreamReader.readFourCC((DataInput)movieFile);
                if (rsrcLen > totalResourceLen) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, String.format("resrouce payload extends beyond parent 'vttR' atom. Available:%d Needed:%d", totalResourceLen, rsrcLen), movieFile.getFilePointer() - 1L).put("Available", String.valueOf(totalResourceLen)).put("Needed", String.valueOf(rsrcLen));
                }
                if (!"rsrc".equals(rsrcTag)) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Illegal atom inside 'vttR':" + rsrcTag, movieFile.getFilePointer() - 1L).put("Illegal atom", rsrcTag);
                }
                totalResourceLen -= 8;
                vttResourcePayload payload = new vttResourcePayload();
                totalResourceLen -= payload.parse(quickTimeParser, movieFile, totalResourceLen);
                this._payloads.add(payload);
            }
            super.parseSampleDescriptionExtension(ctx, quickTimeParser, movieFile, parentMaxOffset);
        }

        public List<vttResourcePayload> payloads() {
            return this._payloads;
        }

        @Override
        public String toString() {
            return super.toString() + vttRSampleDescriptionExtension.propsToString(this.getProperties());
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            return l;
        }
    }

    public class vttResourcePayload {
        String _role = "";
        String _mime_format = "";
        String _mime_format_URI = "";
        List<String> _payloads = Lists.newArrayList();

        public int parse(BaseParser quickTimeParser, SeekableDataInput movieFile, int totalResourceLen) throws IOException, QtFileCorruptException {
            int prevResourceLen = totalResourceLen;
            int typeLen = (int)BitstreamReader.readU32((DataInput)movieFile);
            String typeTag = BitstreamReader.readFourCC((DataInput)movieFile);
            if (typeLen > totalResourceLen) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, String.format("the resource type atom extends beyond parent 'vttR' atom. Available:%d Needed:%d", totalResourceLen, typeLen), movieFile.getFilePointer() - 1L).put("Available", String.valueOf(totalResourceLen)).put("Needed", String.valueOf(typeLen));
            }
            if (!"type".equals(typeTag)) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Illegal atom inside 'vttR':" + typeTag, movieFile.getFilePointer() - 1L).put("Illegal atom", typeTag);
            }
            totalResourceLen -= 8;
            int unused = BitstreamReader.read32(movieFile);
            totalResourceLen -= 4;
            this._role = BitstreamReader.readFourCC((DataInput)movieFile);
            totalResourceLen -= 4;
            this._mime_format = quickTimeParser.readCString(movieFile);
            totalResourceLen -= this._mime_format.length() + 1;
            this._mime_format_URI = quickTimeParser.readCString(movieFile);
            totalResourceLen -= this._mime_format_URI.length() + 1;
            while (totalResourceLen > 8) {
                int dataLen = (int)BitstreamReader.readU32((DataInput)movieFile);
                String dataTag = BitstreamReader.readFourCC((DataInput)movieFile);
                if (dataLen > totalResourceLen) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, String.format("the resource type atom extends beyond parent 'vttR' atom. Available:%d Needed:%d", totalResourceLen, dataLen), movieFile.getFilePointer() - 1L).put("Available", String.valueOf(totalResourceLen)).put("Needed", String.valueOf(dataLen));
                }
                if (!"data".equals(dataTag)) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Illegal atom inside 'vttR':" + typeTag, movieFile.getFilePointer() - 1L).put("Illegal atom", typeTag);
                }
                String dataString = VTTSampleDescription.readStringBytes(movieFile, dataLen - 8);
                totalResourceLen -= dataString.length() + 8;
                this._payloads.add(dataString);
            }
            return prevResourceLen - totalResourceLen;
        }

        public String role() {
            return this._role;
        }

        public String mimeFormat() {
            return this._mime_format;
        }

        public String mimeFormatURI() {
            return this._mime_format_URI;
        }

        public List<String> payloads() {
            return this._payloads;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("role:");
            sb.append(this._role);
            sb.append(",mimeFormat:");
            sb.append(this._mime_format);
            sb.append(",mimeFormatURI:");
            sb.append(this._mime_format_URI);
            sb.append(",payloadCount:");
            sb.append(String.valueOf(this._payloads.size()));
            int totalPayloadSize = 0;
            for (String s : this._payloads) {
                totalPayloadSize += s.length();
            }
            sb.append(",totalPayloadSize:");
            sb.append(String.valueOf(totalPayloadSize));
            return super.toString();
        }
    }

    public class rqdfSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        List<String> _features = Lists.newArrayList();

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            int totalLen = (int)this.getAtomSize() - 8;
            if (totalLen <= 8) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "We were expecting a list of 'feat' but there is not enough space for the atom: totalLen:" + String.valueOf(totalLen), movieFile.getFilePointer() - 1L);
            }
            while (totalLen > 8) {
                int featLen = (int)BitstreamReader.readU32((DataInput)movieFile);
                String featTag = BitstreamReader.readFourCC((DataInput)movieFile);
                if (featLen > totalLen) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, String.format("Feature string extends beyond parent 'rqdf' atom. Available:%d Needed:%d", totalLen, featLen), movieFile.getFilePointer() - 1L).put("Available", String.valueOf(totalLen)).put("Needed", String.valueOf(featLen));
                }
                if (!"feat".equals(featTag)) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Illegal atom inside 'rqdf':" + featTag, movieFile.getFilePointer() - 1L).put("Illegal atom", featTag);
                }
                this._features.add(VTTSampleDescription.readStringBytes(movieFile, featLen - 8));
                totalLen -= featLen;
            }
            super.parseSampleDescriptionExtension(ctx, quickTimeParser, movieFile, parentMaxOffset);
        }

        public List<String> features() {
            return this._features;
        }

        @Override
        public String toString() {
            return super.toString() + rqdfSampleDescriptionExtension.propsToString(this.getProperties());
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("features", Joiner.on((String)",").join(this._features)));
            return l;
        }
    }

    public class vlabSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        String _label = "";

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            int commentLen = (int)this.getAtomSize() - 8;
            this._label = VTTSampleDescription.readStringBytes(movieFile, commentLen);
            super.parseSampleDescriptionExtension(ctx, quickTimeParser, movieFile, parentMaxOffset);
        }

        public String label() {
            return this._label;
        }

        @Override
        public String toString() {
            return super.toString() + vlabSampleDescriptionExtension.propsToString(this.getProperties());
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("label", this._label));
            return l;
        }
    }

    public class vttCSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        String _config = "";

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            int commentLen = (int)this.getAtomSize() - 8;
            this._config = VTTSampleDescription.readStringBytes(movieFile, commentLen);
            super.parseSampleDescriptionExtension(ctx, quickTimeParser, movieFile, parentMaxOffset);
        }

        public String config() {
            return this._config;
        }

        @Override
        public String toString() {
            return super.toString() + vttCSampleDescriptionExtension.propsToString(this.getProperties());
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("config", this._config));
            return l;
        }
    }
}

