/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataAtom;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class TimecodeSampleDescription
extends SampleDescription {
    public static final byte FLAG_DROP_FRAME = 1;
    public static final byte FLAG_24_HOUR_MAX = 2;
    public static final byte FLAG_NEGATIVE_ALLOWED = 4;
    public static final byte FLAG_TAPE_COUNTER = 8;
    protected final byte[] flags = new byte[4];
    protected long timeScalePerFrame;
    protected long frameInRealTime;
    protected int fps;
    protected final byte[] reserved2 = new byte[1];
    protected UserDataAtom sourceTape;

    @Override
    public void parseSampleDescription(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        super.parseSampleDescription(ctx, quickTimeParser, movieFile);
        quickTimeParser.always((int)BitstreamReader.readU32((DataInput)movieFile), 0);
        movieFile.readFully(this.flags);
        this.timeScalePerFrame = BitstreamReader.readU32((DataInput)movieFile);
        this.frameInRealTime = BitstreamReader.readU32((DataInput)movieFile);
        this.fps = BitstreamReader.readU8(movieFile);
        movieFile.readFully(this.reserved2);
    }

    @Override
    public String toString() {
        return "[" + this.trackType + "] " + this.getProperties();
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        super.dumpData(dump);
        dump.write("flags", TimecodeSampleDescription.bytesAsHex(this.flags)).write("timeScalePerFrame", this.timeScalePerFrame).write("frameInRealTime", this.frameInRealTime).write("fps", this.fps).write("sourceTape", this.sourceTape);
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("flags", TimecodeSampleDescription.bytesAsHex(this.flags)));
        l.add(new KeyValuePair("timeScalePerFrame", this.timeScalePerFrame));
        l.add(new KeyValuePair("frameInRealTime", this.frameInRealTime));
        l.add(new KeyValuePair("fps", this.fps));
        if (this.sourceTape != null) {
            l.add(new KeyValuePair("tapeName", this.sourceTape.getValue()));
        }
        l.add(new KeyValuePair("isDropFrame", this.isDropFrame()));
        l.add(new KeyValuePair("is24HourMax", this.is24HourMax()));
        l.add(new KeyValuePair("isNegativeAllowed", this.isNegativeAllowed()));
        l.add(new KeyValuePair("isTapeCounter", this.isTapeCounter()));
        return l;
    }

    public long getTimeScalePerFrame() {
        return this.timeScalePerFrame;
    }

    public long getFrameInRealTime() {
        return this.frameInRealTime;
    }

    public int getFps() {
        return this.fps;
    }

    public boolean isDropFrame() {
        return (this.flags[3] & 1) == 1;
    }

    public boolean is24HourMax() {
        return (this.flags[3] & 2) == 2;
    }

    public boolean isNegativeAllowed() {
        return (this.flags[3] & 4) == 4;
    }

    public boolean isTapeCounter() {
        return (this.flags[3] & 8) == 8;
    }
}

