/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SubtitleSampleDescription
extends SampleDescription {
    long displayFlags;
    byte horizontalJustification;
    byte verticalJustification;
    Tx3gRBGAColor backgroundColor = new Tx3gRBGAColor();
    Rect defaultTextBox = new Rect();
    int startChar;
    int endChar;
    int fontID;
    int fontFace;
    int fontSize;
    Tx3gRBGAColor fontColor = new Tx3gRBGAColor();

    @Override
    public void parseSampleDescription(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        if (!this.dataFormat.equals("tx3g") && !this.dataFormat.equals("drmt")) {
            return;
        }
        this.displayFlags = BitstreamReader.readU32((DataInput)movieFile);
        this.horizontalJustification = movieFile.readByte();
        this.verticalJustification = movieFile.readByte();
        this.backgroundColor.parse(quickTimeParser, movieFile);
        this.defaultTextBox.parse(quickTimeParser, movieFile);
        this.startChar = BitstreamReader.readU16(movieFile);
        this.endChar = BitstreamReader.readU16(movieFile);
        this.fontID = BitstreamReader.readU16(movieFile);
        this.fontFace = BitstreamReader.readU8(movieFile);
        this.fontSize = BitstreamReader.readU8(movieFile);
        this.fontColor.parse(quickTimeParser, movieFile);
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("displayFlags", String.valueOf(this.displayFlags)));
        l.add(new KeyValuePair("horizontalJustification", String.valueOf(this.horizontalJustification)));
        l.add(new KeyValuePair("verticalJustification", String.valueOf(this.verticalJustification)));
        l.add(new KeyValuePair("backgroundColor", String.valueOf(this.backgroundColor)));
        l.add(new KeyValuePair("defaultTextBox", String.valueOf(this.defaultTextBox)));
        l.add(new KeyValuePair("startChar", String.valueOf(this.startChar)));
        l.add(new KeyValuePair("endChar", String.valueOf(this.endChar)));
        l.add(new KeyValuePair("fontID", String.valueOf(this.fontID)));
        l.add(new KeyValuePair("fontFace", String.valueOf(this.fontFace)));
        l.add(new KeyValuePair("fontSize", String.valueOf(this.fontSize)));
        l.add(new KeyValuePair("fontColor", String.valueOf(this.fontColor)));
        return l;
    }

    public static String toHex(long i, int padding) {
        String result = Long.toHexString(i);
        while (result.length() < padding) {
            result = "0" + result;
        }
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + SubtitleSampleDescription.propsToString(this.getProperties());
    }

    @Override
    public SampleDescription.SampleDescriptionExtension createSampleDescriptionExtension(String extensionType, long sdeSize, long sdeOffset) {
        SampleDescription.SampleDescriptionExtension extension = new SampleDescription.SampleDescriptionExtension();
        if (extensionType.equals("ftab")) {
            extension = new ftabSampleDescriptionExtension();
        }
        extension.setAttributes(sdeOffset, sdeSize, extensionType);
        return extension;
    }

    public long getDisplayFlags() {
        return this.displayFlags;
    }

    public byte getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public byte getVerticalJustification() {
        return this.verticalJustification;
    }

    public Tx3gRBGAColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public Rect getDefaultTextBox() {
        return this.defaultTextBox;
    }

    public int getStartChar() {
        return this.startChar;
    }

    public int getEndChar() {
        return this.endChar;
    }

    public int getFontID() {
        return this.fontID;
    }

    public int getFontFace() {
        return this.fontFace;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Tx3gRBGAColor getFontColor() {
        return this.fontColor;
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        super.dumpData(dump);
        dump.write("displayFlags", this.displayFlags != 0L, String.format("%x", this.displayFlags)).write("horizontalJustification", this.horizontalJustification != 0, this.horizontalJustification).write("verticalJustification", this.verticalJustification != 0, this.verticalJustification).write("backgroundColor", this.backgroundColor.getHexString()).write("defaultTextBox", this.defaultTextBox).write("startChar", String.format("%02x", this.startChar)).write("endChar", String.format("%02x", this.endChar)).write("fontId", 0 != this.fontID, this.fontID).write("fontFace", 0 != this.fontFace, this.fontFace).write("fontSize", 0 != this.fontSize, this.fontSize).write("defaultTextBox", this.defaultTextBox);
    }

    public static class Tx3gFontRecord {
        int fontID;
        int nameLength;
        String name;

        public void parse(BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException {
            this.fontID = BitstreamReader.readU16(movieFile, parentMaxOffset);
            this.nameLength = BitstreamReader.readU8(movieFile, parentMaxOffset);
            byte[] stringBytes = new byte[this.nameLength];
            movieFile.readFully(stringBytes);
            this.name = new String(stringBytes, 0, this.nameLength, "ASCII");
        }

        public String toString() {
            return "fontID=" + this.fontID + "; nameLength=" + this.nameLength + "; name=" + this.name;
        }

        public int getFontID() {
            return this.fontID;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Rect {
        int top;
        int left;
        int bottom;
        int right;

        public void parse(BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
            this.top = BitstreamReader.read16(movieFile);
            this.left = BitstreamReader.read16(movieFile);
            this.bottom = BitstreamReader.read16(movieFile);
            this.right = BitstreamReader.read16(movieFile);
        }

        public String toString() {
            return "top=" + this.top + "; left=" + this.left + "; bottom=" + this.bottom + "; right=" + this.right;
        }

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getRight() {
            return this.right;
        }
    }

    public static class Tx3gRBGAColor {
        int red;
        int green;
        int blue;
        int alpha;

        public void parse(BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
            this.red = BitstreamReader.readU8(movieFile);
            this.green = BitstreamReader.readU8(movieFile);
            this.blue = BitstreamReader.readU8(movieFile);
            this.alpha = BitstreamReader.readU8(movieFile);
        }

        public String toString() {
            return "red=" + this.red + "; green=" + this.green + "; blue=" + this.blue + "; alpha=" + this.alpha;
        }

        public String getHexString() {
            return SubtitleSampleDescription.toHex(this.red, 2) + SubtitleSampleDescription.toHex(this.green, 2) + SubtitleSampleDescription.toHex(this.blue, 2) + SubtitleSampleDescription.toHex(this.alpha, 2);
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        public int getAlpha() {
            return this.alpha;
        }
    }

    public class ftabSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        int entryCount;
        List<Tx3gFontRecord> fontEntries = new ArrayList<Tx3gFontRecord>();

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            this.entryCount = BitstreamReader.readU16(movieFile);
            for (int i = 0; i < this.entryCount; ++i) {
                Tx3gFontRecord rec = new Tx3gFontRecord();
                rec.parse(quickTimeParser, movieFile, parentMaxOffset);
                this.fontEntries.add(rec);
            }
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("entryCount", String.valueOf(this.entryCount)));
            l.add(new KeyValuePair("fontEntries", String.valueOf(this.fontEntries)));
            return l;
        }

        @Override
        public String toString() {
            return super.toString() + ftabSampleDescriptionExtension.propsToString(this.getProperties());
        }

        public int getEntryCount() {
            return this.entryCount;
        }

        public List<Tx3gFontRecord> getFontEntries() {
            return this.fontEntries;
        }
    }
}

