/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.chanSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.dac3SampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.dec3SampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.dmixSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.esdsSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.pinfSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.sbtdSampleDescriptorExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.udc2SampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.udi2SampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.waveSampleDescriptionExtension;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import javax.annotation.Nonnull;

public class SoundSampleDescription
extends SampleDescription {
    int version;
    int revisionLevel;
    long vendor;
    int numOfChannels;
    int sampleSize;
    int compressionID;
    int packetSize;
    float sampleRate;
    long samplesPerPacket;
    long bytesPerPacket;
    long bytesPerFrame;
    long bytesPerSample;
    long sizeOfStruct;
    long formatSpecificFlags;
    long lpcmFramesPerAudioPacket;

    @Override
    public void parseSampleDescription(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        this.version = BitstreamReader.read16(movieFile);
        this.revisionLevel = BitstreamReader.read16(movieFile);
        this.vendor = BitstreamReader.readU32((DataInput)movieFile);
        if (this.version == 0 || this.version == 1) {
            this.numOfChannels = BitstreamReader.read16(movieFile);
            this.sampleSize = BitstreamReader.read16(movieFile);
            this.compressionID = BitstreamReader.read16(movieFile);
            this.packetSize = BitstreamReader.read16(movieFile);
            this.sampleRate = BitstreamReader.readFixedU32(movieFile);
        } else if (this.version == 2) {
            quickTimeParser.always(BitstreamReader.read16(movieFile), 3);
            quickTimeParser.always(BitstreamReader.read16(movieFile), 16);
            quickTimeParser.always(BitstreamReader.read16(movieFile), -2);
            quickTimeParser.always(BitstreamReader.read16(movieFile), 0);
            quickTimeParser.always((int)BitstreamReader.readU32((DataInput)movieFile), 65536);
            this.sizeOfStruct = BitstreamReader.readU32((DataInput)movieFile);
            this.sampleRate = (float)BitstreamReader.readFloat64(movieFile);
            this.numOfChannels = (int)BitstreamReader.readU32((DataInput)movieFile);
            quickTimeParser.always(BitstreamReader.read32(movieFile), 0x7F000000);
            this.sampleSize = (int)BitstreamReader.readU32((DataInput)movieFile);
            this.formatSpecificFlags = BitstreamReader.readU32((DataInput)movieFile);
            this.bytesPerPacket = BitstreamReader.readU32((DataInput)movieFile);
            this.lpcmFramesPerAudioPacket = BitstreamReader.readU32((DataInput)movieFile);
        }
        if (this.version == 1) {
            this.samplesPerPacket = BitstreamReader.readU32((DataInput)movieFile);
            this.bytesPerPacket = BitstreamReader.readU32((DataInput)movieFile);
            this.bytesPerFrame = BitstreamReader.readU32((DataInput)movieFile);
            this.bytesPerSample = BitstreamReader.readU32((DataInput)movieFile);
        }
    }

    @Override
    public SampleDescription.SampleDescriptionExtension createSampleDescriptionExtension(String extensionType, long sdeSize, long sdeOffset) {
        SampleDescription.SampleDescriptionExtension extension = new SampleDescription.SampleDescriptionExtension();
        if (extensionType.equals("chan")) {
            extension = new chanSampleDescriptionExtension();
        } else if (extensionType.equals("dac3")) {
            extension = new dac3SampleDescriptionExtension();
        } else if (extensionType.equals("dec3")) {
            extension = new dec3SampleDescriptionExtension();
        } else if (extensionType.equals("esds")) {
            extension = new esdsSampleDescriptionExtension();
        } else if (extensionType.equals("pinf")) {
            extension = new pinfSampleDescriptionExtension();
        } else if (extensionType.equals("wave")) {
            extension = new waveSampleDescriptionExtension();
        } else if (extensionType.equals("dmix")) {
            extension = new dmixSampleDescriptionExtension(this.numOfChannels);
        } else if (extensionType.equals("udc2")) {
            extension = new udc2SampleDescriptionExtension();
        } else if (extensionType.equals("udi2")) {
            extension = new udi2SampleDescriptionExtension();
        } else if (extensionType.equals("sbtd")) {
            extension = new sbtdSampleDescriptorExtension();
        }
        extension.setAttributes(sdeOffset, sdeSize, extensionType);
        return extension;
    }

    public boolean containsAc3SampleDescriptionExtension() {
        return this.findSingleChildOfType(dac3SampleDescriptionExtension.class, false, false) != null;
    }

    public boolean containsEc3SampleDescriptionExtension() {
        return this.findSingleChildOfType(dec3SampleDescriptionExtension.class, false, false) != null;
    }

    @Override
    public String toString() {
        return "[" + this.trackType + "] dataFormat=" + this.dataFormat + "; numOfChannels=" + this.numOfChannels + "; sampleSize=" + this.sampleSize + "; sampleRate=" + this.sampleRate;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRevisionLevel() {
        return this.revisionLevel;
    }

    public long getVendor() {
        return this.vendor;
    }

    public int getNumOfChannels() {
        return this.numOfChannels;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getCompressionID() {
        return this.compressionID;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public long getSamplesPerPacket() {
        return this.samplesPerPacket;
    }

    public long getBytesPerPacket() {
        return this.bytesPerPacket;
    }

    public long getBytesPerFrame() {
        return this.bytesPerFrame;
    }

    public long getBytesPerSample() {
        return this.bytesPerSample;
    }

    public long getSizeOfStruct() {
        return this.sizeOfStruct;
    }

    public long getFormatSpecificFlags() {
        return this.formatSpecificFlags;
    }

    public long getLpcmFramesPerAudioPacket() {
        return this.lpcmFramesPerAudioPacket;
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        super.dumpData(dump);
        dump.write("version", this.version != 0, this.version).write("revisionLevel", this.revisionLevel != 0, this.revisionLevel).write("vendor", this.vendor != 0L, this.vendor).write("numChannels", this.numOfChannels != 0, this.numOfChannels).write("compressionId", this.compressionID != -1, this.compressionID).write("packetSize", this.packetSize != 0, this.packetSize).write("sampleRate", Float.valueOf(this.sampleRate)).write("samplesPerPacket", this.samplesPerPacket != 0L, this.samplesPerPacket).write("bytesPerPacket", this.bytesPerFrame != 0L, this.bytesPerPacket).write("bytesPerFrame", this.bytesPerFrame != 0L, this.bytesPerFrame).write("bytesPerSample", this.bytesPerSample != 0L, this.bytesPerSample).write("formatSpecificFlags", this.formatSpecificFlags != 0L, String.format("%x", this.formatSpecificFlags)).write("lpcmFramesPerAudioPacket", this.lpcmFramesPerAudioPacket != 0L, this.lpcmFramesPerAudioPacket);
    }
}

