/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.Dumpsterable;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class SampleDescription
extends Atom
implements Container,
DataDumpable {
    List<SampleDescriptionExtension> atoms = new LinkedList<SampleDescriptionExtension>();
    String trackType;
    String dataFormat;
    int dataReference;

    public List<SampleDescriptionExtension> getChildren() {
        return this.atoms;
    }

    @Override
    public <T> Iterable<T> getChildren(@Nonnull Class<T> ofType) {
        assert (null != ofType) : "Child type is a required parameter";
        return Iterables.filter(this.getChildren(), ofType);
    }

    public void setSampleDescriptionAttributes(String type, String dataFormat, int dataReference) {
        this.trackType = type;
        this.dataFormat = dataFormat;
        this.dataReference = dataReference;
    }

    public void parseSampleDescription(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
    }

    public SampleDescriptionExtension createSampleDescriptionExtension(String extensionType, long sdeSize, long sdeOffset) {
        SampleDescriptionExtension extension = new SampleDescriptionExtension();
        extension.setAttributes(sdeOffset, sdeSize, extensionType);
        return extension;
    }

    public void addSampleDescriptionExtension(SampleDescriptionExtension extension) {
        this.atoms.add(extension);
    }

    @Override
    public String toString() {
        return "[" + this.trackType + "] " + this.getProperties();
    }

    @Override
    public <T> List<T> findChildrenOfType(Class<T> clazz, boolean recurse) {
        return Container.Searcher.findChildrenOfType(clazz, recurse, this);
    }

    @Override
    public <T> T findSingleChildOfType(Class<T> clazz, boolean recurse, boolean failOnZero) {
        return Container.Searcher.findSingleChildOfType(clazz, recurse, failOnZero, true, this);
    }

    public List<SampleDescriptionExtension> getAtoms() {
        return this.atoms;
    }

    public String getTrackType() {
        return this.trackType;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public int getDataReference() {
        return this.dataReference;
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.write("trackType", this.trackType).write("dataFormat", this.dataFormat).write("dataReference", this.dataReference != 1, this.dataReference);
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("trackType", this.trackType));
        l.add(new KeyValuePair("dataFormat", this.dataFormat));
        l.add(new KeyValuePair("dataReference", this.dataReference + ""));
        return l;
    }

    public static class SampleDescriptionExtension
    extends QTContainerAtom
    implements Dumpsterable,
    DataDumpable {
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        }

        @Override
        public String toString() {
            return "[" + this.getExtensionType() + "] " + this.getProperties();
        }

        public String getExtensionType() {
            return this.atomType;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            LinkedList<KeyValuePair> l = new LinkedList<KeyValuePair>();
            l.add(new KeyValuePair("size", this.size + ""));
            return l;
        }

        @Override
        public void dumpData(@Nonnull DataDump dump) {
        }
    }
}

