/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import com.apple.jingle.leghorn.bitstream.avc.vui.ChromaFormat;
import com.apple.jingle.leghorn.bitstream.hevc.HevcNalUnitHeader;
import com.apple.jingle.leghorn.bitstream.hevc.HevcNalUnitType;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.sei.ContentLightLevelInfoSeiMessage;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.sei.MasteringDisplayColorVolumeSeiMessage;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class HvccSampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension {
    private int configurationVersion;
    private int generalProfileSpace;
    private boolean generalTierFlag;
    private int generalProfile;
    private long generalProfileCompatibilityFlags;
    private long generalConstraintIndicatorFlags;
    private int generalLevel;
    private int minSpatialSegmentation;
    private int parallelismType;
    private ChromaFormat chromaFormat;
    private int bitDepthLuma;
    private int bitDepthChroma;
    private int avgFrameRateBits;
    private int constantFrameRateBits;
    private int numTemporalLayers;
    private boolean temporalIdNested;
    private int nalUnitLengthSize;
    private Map<HevcNalUnitType, Boolean> nalUnitCompleteness;
    private Set<String> seis;
    private List<Object> children;

    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        int configurationVersion = BitstreamReader.readU8(movieFile, parentMaxOffset);
        if (configurationVersion != 1) {
            throw new IOException("Unsupport configuration version: " + configurationVersion + ", was expecting 1");
        }
        int byteData = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.generalProfileSpace = byteData >>> 6;
        this.generalTierFlag = (byteData & 0x20) != 0;
        this.generalProfile = byteData & 0x1F;
        this.generalProfileCompatibilityFlags = BitstreamReader.readU32(movieFile, parentMaxOffset);
        this.generalConstraintIndicatorFlags = BitstreamReader.readU32(movieFile, parentMaxOffset) << 16;
        this.generalConstraintIndicatorFlags |= (long)BitstreamReader.readU16(movieFile, parentMaxOffset);
        this.generalLevel = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.minSpatialSegmentation = BitstreamReader.readU16(movieFile, parentMaxOffset) & 0xFFF;
        this.parallelismType = BitstreamReader.readU8(movieFile, parentMaxOffset) & 3;
        this.chromaFormat = ChromaFormat.Defined.forCode(BitstreamReader.readU8(movieFile, parentMaxOffset) & 3, false);
        this.bitDepthLuma = (BitstreamReader.readU8(movieFile, parentMaxOffset) & 7) + 8;
        this.bitDepthChroma = (BitstreamReader.readU8(movieFile, parentMaxOffset) & 7) + 8;
        this.avgFrameRateBits = BitstreamReader.readU16(movieFile, parentMaxOffset);
        byteData = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.constantFrameRateBits = byteData >>> 6;
        this.numTemporalLayers = byteData >>> 3 & 3;
        this.temporalIdNested = (byteData & 4) != 0;
        this.nalUnitLengthSize = (byteData & 3) + 1;
        int numOfArrays = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.nalUnitCompleteness = new LinkedHashMap<HevcNalUnitType, Boolean>(numOfArrays);
        this.children = new ArrayList<Object>();
        this.seis = new TreeSet<String>();
        for (int arrayIdx = 0; arrayIdx < numOfArrays; ++arrayIdx) {
            byteData = BitstreamReader.readU8(movieFile, parentMaxOffset);
            boolean arrayCompleteness = (byteData & 0x80) != 0;
            HevcNalUnitType nalUnitType = HevcNalUnitType.Defined.forCode(byteData & 0x3F);
            int nalUnitCount = BitstreamReader.readU16(movieFile, parentMaxOffset);
            this.nalUnitCompleteness.put(nalUnitType, arrayCompleteness);
            for (int nalUnitIdx = 0; nalUnitIdx < nalUnitCount; ++nalUnitIdx) {
                int nalUnitLength = BitstreamReader.readU16(movieFile, parentMaxOffset);
                HevcNalUnitHeader nalHeader = new HevcNalUnitHeader(movieFile, nalUnitLength);
                if (nalUnitType instanceof HevcNalUnitType.Defined) {
                    block0 : switch ((HevcNalUnitType.Defined)nalUnitType) {
                        case PREFIX_SEI: {
                            RawByteSequencePayloadReader reader = nalHeader.payloadReader();
                            int payloadId = HvccSampleDescriptionExtension.readSeiIntValue(reader);
                            this.seis.add(nalUnitType + "." + payloadId);
                            HvccSampleDescriptionExtension.readSeiIntValue(reader);
                            switch (payloadId) {
                                case 137: {
                                    this.children.add(new MasteringDisplayColorVolumeSeiMessage(reader));
                                    break block0;
                                }
                                case 144: {
                                    this.children.add(new ContentLightLevelInfoSeiMessage(reader));
                                    break block0;
                                }
                            }
                            this.children.add(nalHeader);
                            break;
                        }
                        case SUFFIX_SEI: {
                            RawByteSequencePayloadReader reader = nalHeader.payloadReader();
                            int payloadId = HvccSampleDescriptionExtension.readSeiIntValue(reader);
                            this.seis.add(nalUnitType + "." + payloadId);
                            break;
                        }
                        default: {
                            this.seis.add(nalUnitType.toString());
                            this.children.add(nalHeader);
                            break;
                        }
                    }
                    continue;
                }
                this.seis.add(Integer.toString(nalUnitType.getCode()));
                this.children.add(nalHeader);
            }
        }
    }

    public static final int readSeiIntValue(RawByteSequencePayloadReader reader) throws IOException {
        int data;
        int value = 0;
        do {
            data = reader.readBits(8);
            value += data;
        } while (data == 255);
        return value;
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        super.dumpData(dump);
        dump.write("version", this.configurationVersion).write("profileSpace", this.generalProfileSpace).write("profile", this.generalProfile).write("level", this.generalLevel).write("tier", this.generalTierFlag).write("profileCompatibilityFlags", String.format("0x%08x", this.generalProfileCompatibilityFlags)).write("constraintIndicatorFlags", String.format("0x%012x", this.generalConstraintIndicatorFlags)).write("minSpatialSegmentation", this.minSpatialSegmentation).write("parallelismType", this.parallelismType).write("chromaFormat", this.chromaFormat).write("bitDepthChroma", this.bitDepthChroma).write("bitDepthLuma", this.bitDepthLuma).write("temporalIdNested", this.temporalIdNested).write("temporalLayers", this.numTemporalLayers).write("seis", !this.seis.isEmpty(), this.seis.toString().replaceAll("[\\[\\]]", ""));
        for (Map.Entry<HevcNalUnitType, Boolean> entry : this.nalUnitCompleteness.entrySet()) {
            dump.write("complete." + entry.getKey(), entry.getValue());
        }
        for (Object child : this.children) {
            if (!(child instanceof DataDumpable)) continue;
            ((DataDumpable)child).dumpData(dump);
        }
    }
}

