/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import javax.annotation.Nonnull;

public class DvccSampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension {
    private int versionMajor;
    private int versionMinor;
    private int profile;
    private int level;
    private boolean rpuPresent;
    private boolean elPresent;
    private boolean blPresent;

    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        this.versionMajor = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.versionMinor = BitstreamReader.readU8(movieFile, parentMaxOffset);
        int byteData = BitstreamReader.readU16(movieFile, parentMaxOffset);
        this.profile = byteData >>> 9 & 0x7F;
        this.level = byteData >>> 3 & 0x3F;
        this.rpuPresent = (byteData & 4) != 0;
        this.elPresent = (byteData & 2) != 0;
        this.blPresent = (byteData & 1) != 0;
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        super.dumpData(dump);
        dump.write("version", this.versionMajor + "." + this.versionMinor).write("profile", this.profile + "." + this.level).write("rpuPresent", this.rpuPresent, this.rpuPresent).write("elPresent", this.elPresent, this.elPresent).write("blPresent", this.blPresent, this.blPresent);
    }
}

