/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.bitstream.avc.NalUnitHeader;
import com.apple.jingle.leghorn.bitstream.avc.NalUnitType;
import com.apple.jingle.leghorn.bitstream.avc.PictureParameterSet;
import com.apple.jingle.leghorn.bitstream.avc.SequenceParameterSet;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class AvccSampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension {
    int version;
    int profile;
    int compatability;
    float level;
    List<PictureParameterSet> ppsList;
    List<SequenceParameterSet> spsList;
    Set<String> spsCodecLabelSet;
    String rawAVCC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpData(@Nonnull DataDump dump) {
        super.dumpData(dump);
        dump.write("version", this.version).write("profile", this.profile).write("compatability", this.compatability).write("level", Float.valueOf(this.level));
        int spsIdx = 0;
        for (SequenceParameterSet sps : this.spsList) {
            try (DataDump spsDump = dump.child("sps." + spsIdx++);){
                sps.dumpData(spsDump);
            }
        }
        int ppsIdx = 0;
        for (PictureParameterSet pps : this.ppsList) {
            try (DataDump ppsDump = dump.child("pps." + ppsIdx++);){
                pps.dumpData(ppsDump);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        int payloadSize = (int)(this.size - 8L);
        byte[] rawPayload = new byte[payloadSize];
        movieFile.readFully(rawPayload);
        movieFile.seek(movieFile.getFilePointer() - (long)payloadSize);
        StringBuilder sb = new StringBuilder();
        for (byte b : rawPayload) {
            sb.append(String.format("%02X", b));
        }
        this.rawAVCC = sb.toString();
        this.version = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.profile = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.compatability = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.level = (float)BitstreamReader.readU8(movieFile, parentMaxOffset) / 10.0f;
        movieFile.skipBytes(1);
        int nSPS = BitstreamReader.readU8(movieFile, parentMaxOffset) & 0x1F;
        this.spsList = new ArrayList<SequenceParameterSet>(nSPS);
        this.spsCodecLabelSet = new HashSet<String>(nSPS);
        for (int currentSPS = 0; currentSPS < nSPS; ++currentSPS) {
            byte[] spsBytes = new byte[BitstreamReader.readU16(movieFile, parentMaxOffset)];
            movieFile.readFully(spsBytes);
            sb = new StringBuilder("avc1.");
            for (int idx = 0; idx < 3; ++idx) {
                sb.append(String.format("%02X", spsBytes[idx]));
            }
            this.spsCodecLabelSet.add(sb.toString());
            try (ByteArraySeekableDataInput rbsp = new ByteArraySeekableDataInput(spsBytes, (long)spsBytes.length);){
                NalUnitHeader header = new NalUnitHeader((SeekableDataInput)rbsp, spsBytes.length);
                if (header.unitType() != NalUnitType.Defined.sps) continue;
                SequenceParameterSet sps = new SequenceParameterSet(header);
                this.spsList.add(sps);
                continue;
            }
        }
        int nPPS = BitstreamReader.readU8(movieFile, parentMaxOffset);
        this.ppsList = new ArrayList<PictureParameterSet>(nPPS);
        for (int currentPPS = 0; currentPPS < nPPS; ++currentPPS) {
            int ppsLength = BitstreamReader.readU16(movieFile, parentMaxOffset);
            byte[] ppsBytes = new byte[ppsLength];
            movieFile.readFully(ppsBytes);
            try (ByteArraySeekableDataInput rbsp = new ByteArraySeekableDataInput(ppsBytes, (long)ppsBytes.length);){
                NalUnitHeader header = new NalUnitHeader((SeekableDataInput)rbsp, ppsBytes.length);
                if (header.unitType() != NalUnitType.Defined.pps) continue;
                PictureParameterSet pps = new PictureParameterSet(header);
                this.ppsList.add(pps);
                continue;
            }
        }
    }

    public String getRawAVCC() {
        return this.rawAVCC;
    }

    public List<PictureParameterSet> getPPSList() {
        return this.ppsList;
    }

    public List<SequenceParameterSet> getSPSList() {
        return this.spsList;
    }

    public Set<String> getSPSCodecLabelList() {
        return this.spsCodecLabelSet;
    }

    public String getProfileString() {
        switch (this.profile) {
            case 66: {
                return "Baseline";
            }
            case 77: {
                return "Main";
            }
            case 88: {
                return "Extended";
            }
            case 100: {
                return "High";
            }
        }
        return "Unknown";
    }

    @Override
    public String toString() {
        return "[" + this.getExtensionType() + "] profile=" + this.getProfileString() + "; level=" + this.level + "; PPS[]=" + this.ppsList + "; SPS[]=" + this.spsList;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public int getProfile() {
        return this.profile;
    }

    public int getCompatability() {
        return this.compatability;
    }

    public float getLevel() {
        return this.level;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("version", this.version + ""));
        l.add(new KeyValuePair("profile", this.profile + " (" + this.getProfileString() + ")"));
        l.add(new KeyValuePair("compatability", this.compatability + ""));
        l.add(new KeyValuePair("level", this.level + ""));
        l.add(new KeyValuePair("PPS[]", this.ppsList));
        l.add(new KeyValuePair("SPS[]", this.spsList));
        return l;
    }
}

