/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.io.output.CountingOutputStream;

public class MovieOutputStream
extends CountingOutputStream {
    private static final long MAX_32BIT = (long)Math.pow(2.0, 32.0);
    private static final boolean UNSIGNED = false;
    private static final boolean SIGNED = true;

    public MovieOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public long getByteLength() {
        return this.getByteCount();
    }

    public void writeAtomHeader(String type, long size) throws IOException {
        if (size > MAX_32BIT) {
            this.writeU32(1L);
            this.writeFourCC(type);
            this.writeU64(size + 16L);
        } else {
            this.writeU32(size + 8L);
            this.writeFourCC(type);
        }
    }

    public void writeUnboundedLastAtomHeader(String type) throws IOException {
        this.writeU32(0L);
        this.writeFourCC(type);
    }

    public void writeFourCC(String type) throws IOException {
        this.write(type.getBytes("ISO8859_1"));
    }

    public void writeU8(long number) throws IOException {
        this.writeNumber(number, false, 8);
    }

    public void writeU16(long number) throws IOException {
        this.writeNumber(number, false, 16);
    }

    public void writeU32(long ... numbers) throws IOException {
        for (long number : numbers) {
            this.writeNumber(number, false, 32);
        }
    }

    public void writeU64(long number) throws IOException {
        this.writeNumber(number, false, 64);
    }

    private void writeNumber(long number, boolean signed, int maxBits) throws IOException {
        if (!signed && number < 0L) {
            throw new IllegalArgumentException("number " + number + " cannot be negative for unsigned writes");
        }
        BigInteger bi = BigInteger.valueOf(number);
        if (bi.bitLength() > maxBits) {
            throw new IllegalArgumentException("number " + number + " would overflow maximum bits " + maxBits);
        }
        byte[] biBytes = bi.toByteArray();
        maxBits -= bi.bitLength();
        while (maxBits >= 8) {
            this.write(new byte[]{0});
            maxBits -= 8;
        }
        int offset = (int)((double)biBytes.length - Math.ceil((double)bi.bitLength() / 8.0));
        this.write(biBytes, offset, biBytes.length - offset);
    }

    public void writeDate(Date date) throws IOException {
        long secondsInAYear = 31557600L;
        long numberOfSecondsFromQuicktimeEpochToJavaEpoch = 66L * secondsInAYear;
        long secondsFromJavaEpochToDateTime = date.getTime() / 1000L;
        long dateToWrite = numberOfSecondsFromQuicktimeEpochToJavaEpoch + secondsFromJavaEpochToDateTime;
        this.writeU32(dateToWrite);
    }

    public void writeFixed16(float number) throws IOException {
        long wholePart = (long)number;
        this.writeNumber(wholePart, true, 8);
        this.writeNumber((long)((double)(number - (float)wholePart) * Math.pow(2.0, 8.0)), false, 8);
    }

    public void writeFixed32(double number) throws IOException {
        long wholePart = (long)number;
        this.writeNumber(wholePart, true, 16);
        this.writeNumber((long)((number - (double)wholePart) * Math.pow(2.0, 16.0)), false, 16);
    }

    public void writeFixedU32(double number) throws IOException {
        long wholePart = (long)number;
        this.writeNumber(wholePart, false, 16);
        this.writeNumber((long)((number - (double)wholePart) * Math.pow(2.0, 16.0)), false, 16);
    }

    public void writeFixed2L30R(double number) throws IOException {
        long wholePart = (long)number;
        this.writeNumber((long)((number - (double)wholePart) * Math.pow(2.0, 30.0)), false, 32);
    }
}

