/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.exporters;

import com.apple.jingle.leghorn.quicktime.AtomInputStream;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.atoms.EditListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.leghorn.quicktime.samples.BaseSample;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class VideoTrackSampleExporter {
    protected TrackAtom trackAtom;
    protected SampleTableAtom sampleTableAtom;
    protected SampleSizeAtom sampleSizeAtom;
    protected SampleTableAtom.SampleCursor sampleCursor;
    protected SeekableDataInput seekableDataInput;
    protected BaseParser parser;
    protected MediaHeaderAtom mediaHeaderAtom;
    protected long timeScale;
    protected EditListAtom editListAtom;
    protected static final Logger LOG = Logger.getLogger(VideoTrackSampleExporter.class);

    public VideoTrackSampleExporter(BaseParser parser, SeekableDataInput seekableDataInput, TrackAtom trackAtom) {
        this.trackAtom = trackAtom;
        this.parser = parser;
        this.seekableDataInput = seekableDataInput;
        TrackAtom.Cursor trackAtomCursor = this.trackAtom.new TrackAtom.Cursor();
        MediaAtom mediaAtom = trackAtomCursor.getMediaAtom();
        MediaAtom.Cursor mediaAtomCursor = mediaAtom.new MediaAtom.Cursor();
        this.mediaHeaderAtom = mediaAtomCursor.getMediaHeaderAtom();
        this.editListAtom = trackAtomCursor.getEditListAtom();
        if (!this.editListAtom.isEditListContinuous()) {
            LOG.warn((Object)("video track with a non-continuous edit list " + this.editListAtom.toDetailedString()));
        }
        MediaInformationAtom mediaInformationAtom = mediaAtomCursor.getMediaInformationAtom();
        MediaInformationAtom.Cursor mediaHeaderAtomCursor = mediaInformationAtom.new MediaInformationAtom.Cursor();
        this.sampleTableAtom = mediaHeaderAtomCursor.getSampleTableAtom();
        this.sampleSizeAtom = mediaHeaderAtomCursor.getSampleSizeAtom();
        this.sampleCursor = this.sampleTableAtom.new SampleTableAtom.SampleCursor();
        this.timeScale = this.mediaHeaderAtom.getTimeScale();
    }

    public void exportTrack(Delegate delegate) throws IOException {
        while (this.sampleCursor.nextSample()) {
            LOG.debug((Object)this.sampleCursor);
            BaseSample sample = new BaseSample();
            sample.parseSample(this.parser, this.seekableDataInput, this.sampleCursor);
            AtomInputStream sampleInputStream = new AtomInputStream(this.seekableDataInput, this.sampleCursor);
            delegate.didReadSample(this.sampleCursor, sampleInputStream);
            IOUtils.closeQuietly((InputStream)sampleInputStream);
        }
    }

    public static interface Delegate {
        public void didReadSample(SampleTableAtom.SampleCursor var1, InputStream var2);
    }
}

