/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.exporters;

import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.AtomInputStream;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.atoms.ChunkOffsetAtom;
import com.apple.jingle.leghorn.quicktime.atoms.EditListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleDescriptionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToChunk;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackHeaderAtom;
import com.apple.jingle.leghorn.quicktime.io.MovieOutputStream;
import com.apple.jingle.leghorn.timecode.CMTime;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.IOUtils;

@NotThreadSafe
public class MovieSegmentExporter {
    protected SeekableDataInput defaultSeekableDataInput;
    protected MovieHeaderAtom movieHeader;
    protected List<TrackOutputSource> tracks = new ArrayList<TrackOutputSource>(1);
    protected CMTime duration;
    protected TrackOutputSource currentTrackOutputSource;

    public void addTrack(SeekableDataInput sdi, TrackAtom track, CMTime mediaStart, CMTime mediaEnd) {
        if (this.defaultSeekableDataInput == null) {
            this.defaultSeekableDataInput = sdi;
        }
        TrackOutputSource outputSource = new TrackOutputSource(sdi, track, mediaStart, mediaEnd);
        this.duration = mediaEnd.subtract(mediaStart);
        this.movieHeader = ((MovieAtom)track.getParent()).findChild(MovieHeaderAtom.class, Container.Searcher.Option.FAIL_ON_ZERO);
        this.tracks.add(outputSource);
    }

    public void setDefaultDataInput(SeekableDataInput seekableDataInput) {
        this.defaultSeekableDataInput = seekableDataInput;
    }

    public void export(OutputStream outputStream) throws IOException {
        if (this.tracks.isEmpty()) {
            throw new IllegalArgumentException("No tracks to export!");
        }
        MovieOutputStream movieOutputStream = new MovieOutputStream(outputStream);
        this.writeFileTypeAtom(movieOutputStream);
        for (TrackOutputSource track : this.tracks) {
            track.writeMediaData(movieOutputStream);
        }
        ByteArrayOutputStream atomBytes = new ByteArrayOutputStream();
        MovieOutputStream atomOutputStream = new MovieOutputStream(atomBytes);
        this.writeAtom(this.movieHeader, atomOutputStream);
        for (TrackOutputSource track : this.tracks) {
            this.writeTrack(track, atomOutputStream);
        }
        movieOutputStream.writeAtomHeader("moov", atomOutputStream.getByteLength());
        movieOutputStream.write(atomBytes.toByteArray());
    }

    private void writeFileTypeAtom(MovieOutputStream movieOutputStream) throws IOException {
        movieOutputStream.writeU32(32L);
        movieOutputStream.writeFourCC("ftyp");
        movieOutputStream.writeFourCC("qt  ");
        movieOutputStream.write(new byte[]{32, 7, 9, 4});
        movieOutputStream.writeFourCC("qt  ");
        movieOutputStream.writeU32(0L, 0L, 0L);
    }

    private void writeMovieHeaderAtom(MovieHeaderAtom movieHeader, MovieOutputStream outputStream) throws IOException {
        this.writeAtomHeader(movieHeader, outputStream);
        outputStream.writeDate(movieHeader.getCreationTime());
        outputStream.writeDate(movieHeader.getModificationTime());
        outputStream.writeU32(this.duration.getTimeScale(), this.duration.getTimeValue());
        outputStream.writeFixed32(movieHeader.getPreferredRate());
        outputStream.writeU16(movieHeader.getPreferredVolume());
        outputStream.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        this.writeIdentityMatrix(outputStream);
        outputStream.writeU32(0L, 0L, 0L, 0L, 0L, 0L);
        outputStream.writeU32(movieHeader.getNextTrackId());
    }

    private void writeIdentityMatrix(MovieOutputStream outputStream) throws IOException {
        outputStream.writeFixed32(1.0);
        outputStream.writeFixed32(0.0);
        outputStream.write(new byte[]{0, 0, 0, 0});
        outputStream.writeFixed32(0.0);
        outputStream.writeFixed32(1.0);
        outputStream.write(new byte[]{0, 0, 0, 0});
        outputStream.writeFixed32(0.0);
        outputStream.writeFixed32(0.0);
        outputStream.write(new byte[]{64, 0, 0, 0});
    }

    protected void writeTrack(TrackOutputSource track, MovieOutputStream outputStream) throws IOException {
        this.currentTrackOutputSource = track;
        this.writeAtom(track.track, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAtom(Atom atom, MovieOutputStream outputStream) throws IOException {
        boolean writeHeader = true;
        String type = atom.getAtomType();
        ByteArrayOutputStream atomBytes = new ByteArrayOutputStream();
        try (MovieOutputStream atomOutputStream = new MovieOutputStream(atomBytes);){
            if (type.equals("tapt") || type.equals("tref")) {
                return;
            }
            if (atom instanceof MovieHeaderAtom) {
                this.writeMovieHeaderAtom((MovieHeaderAtom)atom, atomOutputStream);
            } else if (atom instanceof TrackHeaderAtom) {
                this.writeTrackHeaderAtom((TrackHeaderAtom)atom, atomOutputStream);
            } else if (atom instanceof MediaHeaderAtom) {
                this.writeMediaHeaderAtom((MediaHeaderAtom)atom, atomOutputStream);
            } else if (atom instanceof SampleToTimeAtom) {
                this.writeSampleToTimeAtom((SampleToTimeAtom)atom, atomOutputStream);
            } else if (atom instanceof SampleSizeAtom) {
                this.writeSampleSizeAtom((SampleSizeAtom)atom, atomOutputStream);
            } else if (atom instanceof SampleToChunk) {
                this.writeSampleToChunkAtom((SampleToChunk)atom, atomOutputStream);
            } else if (atom instanceof EditListAtom) {
                this.writeEditListAtom((EditListAtom)atom, atomOutputStream);
            } else if (atom instanceof ChunkOffsetAtom) {
                type = "co64";
                this.writeChunkOffsetAtom((ChunkOffsetAtom)atom, atomOutputStream);
            } else if (atom instanceof QTContainerAtom && !(atom instanceof SampleDescriptionsAtom)) {
                for (Atom atom2 : ((QTContainerAtom)atom).getChildren()) {
                    this.writeAtom(atom2, atomOutputStream);
                }
            } else {
                writeHeader = false;
                AtomInputStream atomInputStream = new AtomInputStream(this.defaultSeekableDataInput, atom);
                IOUtils.copy((InputStream)atomInputStream, (OutputStream)((Object)outputStream));
            }
        }
        if (atomOutputStream.getByteCount() > 0L) {
            if (writeHeader) {
                outputStream.writeAtomHeader(type, atomOutputStream.getByteLength());
            }
            outputStream.write(atomBytes.toByteArray());
        }
    }

    private void writeEditListAtom(EditListAtom atom, MovieOutputStream atomOutputStream) throws IOException {
        this.writeAtomHeader(atom, atomOutputStream);
        atomOutputStream.writeU32(1L);
        atomOutputStream.writeU32(this.duration.getTimeValue());
        atomOutputStream.writeU32(0L);
        atomOutputStream.writeFixedU32(1.0);
    }

    private void writeMediaHeaderAtom(MediaHeaderAtom atom, MovieOutputStream atomOutputStream) throws IOException {
        this.writeAtomHeader(atom, atomOutputStream);
        atomOutputStream.writeDate(atom.getCreationTime());
        atomOutputStream.writeDate(atom.getModificationTime());
        atomOutputStream.writeU32(this.duration.getTimeScale());
        atomOutputStream.writeU32(this.duration.getTimeValue());
        atomOutputStream.writeU16(atom.getLanguage());
        atomOutputStream.writeU16(atom.getQuality());
    }

    private void writeSampleSizeAtom(SampleSizeAtom atom, MovieOutputStream atomOutputStream) throws IOException {
        this.writeAtomHeader(atom, atomOutputStream);
        long samples = this.currentTrackOutputSource.getEndSampleNumber() - this.currentTrackOutputSource.getBeginSampleNumber() + 1L;
        atomOutputStream.writeU32(0L, samples);
        SampleTableAtom.SampleCursor sampleCursor = this.currentTrackOutputSource.mediaInfoCursor.getSampleTableAtom().new SampleTableAtom.SampleCursor();
        sampleCursor.gotoSample(this.currentTrackOutputSource.getBeginSampleNumber());
        atomOutputStream.writeU32(sampleCursor.getSampleLength());
        while (sampleCursor.hasNextSample() && sampleCursor.getSampleNumber() < this.currentTrackOutputSource.getEndSampleNumber()) {
            sampleCursor.nextSample();
            atomOutputStream.writeU32(sampleCursor.getSampleLength());
        }
    }

    private void writeChunkOffsetAtom(ChunkOffsetAtom atom, MovieOutputStream atomOutputStream) throws IOException {
        this.writeAtomHeader(atom, atomOutputStream);
        atomOutputStream.writeU32(1L);
        atomOutputStream.writeU64(this.currentTrackOutputSource.getChunkLocation());
    }

    private void writeSampleToChunkAtom(SampleToChunk atom, MovieOutputStream atomOutputStream) throws IOException {
        this.writeAtomHeader(atom, atomOutputStream);
        long samples = this.currentTrackOutputSource.getEndSampleNumber() - this.currentTrackOutputSource.getBeginSampleNumber() + 1L;
        atomOutputStream.writeU32(1L, 1L, samples, 1L);
    }

    private void writeSampleToTimeAtom(SampleToTimeAtom atom, MovieOutputStream atomOutputStream) throws IOException {
        this.writeAtomHeader(atom, atomOutputStream);
        LinkedList<SampleToTimeAtom.TableEntry> countToTimeTable = new LinkedList<SampleToTimeAtom.TableEntry>();
        SampleTableAtom.SampleCursor sampleCursor = this.currentTrackOutputSource.mediaInfoCursor.getSampleTableAtom().new SampleTableAtom.SampleCursor();
        sampleCursor.gotoSample(this.currentTrackOutputSource.getBeginSampleNumber());
        long currentCount = 1L;
        long currentDuration = sampleCursor.getSampleDuration() - this.currentTrackOutputSource.getBeginSampleTimeOffset();
        while (sampleCursor.hasNextSample() && sampleCursor.getSampleNumber() < this.currentTrackOutputSource.getEndSampleNumber()) {
            sampleCursor.nextSample();
            if (sampleCursor.getSampleDuration() == currentDuration) {
                ++currentCount;
                continue;
            }
            countToTimeTable.add(new SampleToTimeAtom.TableEntry(currentCount, currentDuration));
            currentDuration = sampleCursor.getSampleDuration();
            currentCount = 1L;
        }
        countToTimeTable.add(new SampleToTimeAtom.TableEntry(currentCount, currentDuration));
        atomOutputStream.writeU32(countToTimeTable.size());
        for (SampleToTimeAtom.TableEntry entry : countToTimeTable) {
            atomOutputStream.writeU32(entry.getSampleCount());
            atomOutputStream.writeU32(entry.getSampleDuration());
        }
    }

    private void writeTrackHeaderAtom(TrackHeaderAtom atom, MovieOutputStream atomOutputStream) throws IOException {
        this.writeAtomHeader(atom, atomOutputStream);
        atomOutputStream.writeDate(atom.getCreationTime());
        atomOutputStream.writeDate(atom.getModificationTime());
        atomOutputStream.writeU32(atom.getTrackId());
        atomOutputStream.writeU32(0L);
        atomOutputStream.writeU32(this.duration.getTimeValue());
        atomOutputStream.writeU32(0L, 0L);
        atomOutputStream.writeU16(atom.getLayer());
        atomOutputStream.writeU16(atom.getAlternateGroup());
        atomOutputStream.writeFixed16(atom.getVolume());
        atomOutputStream.writeU16(0L);
        this.writeIdentityMatrix(atomOutputStream);
        atomOutputStream.writeFixed32(atom.getWidth());
        atomOutputStream.writeFixed32(atom.getHeight());
    }

    private void writeAtomHeader(QTAtom fullAtom, MovieOutputStream atomOutputStream) throws IOException {
        atomOutputStream.writeU8(fullAtom.getVersion());
        atomOutputStream.write(fullAtom.getFlags());
    }

    private class TrackOutputSource {
        SeekableDataInput seekableDataInput;
        TrackAtom track;
        CMTime mediaStart;
        CMTime mediaEnd;
        long location;
        long mediaDataSize;
        protected long beginSampleNumber = 1L;
        protected long beginSampleTimeOffset = 0L;
        protected long endSampleNumber = 1L;
        protected long endSampleTimeOffset = 0L;
        MediaInformationAtom.Cursor mediaInfoCursor;

        public TrackOutputSource(SeekableDataInput sdi, TrackAtom track, CMTime mediaStart, CMTime mediaEnd) {
            this.seekableDataInput = sdi;
            this.track = track;
            this.location = 0L;
            TrackAtom.Cursor trackCursor = track.new TrackAtom.Cursor();
            MediaAtom.Cursor mediaCursor = trackCursor.getMediaAtom().new MediaAtom.Cursor();
            this.mediaInfoCursor = mediaCursor.getMediaInformationAtom().new MediaInformationAtom.Cursor();
            this.mediaStart = mediaStart.MakeTimeWithNewScale(mediaCursor.getMediaHeaderAtom().getTimeScale());
            this.mediaEnd = mediaEnd.MakeTimeWithNewScale(mediaCursor.getMediaHeaderAtom().getTimeScale());
            this.targetSamples();
            this.calculateSize();
        }

        private void calculateSize() {
            SampleTableAtom.SampleCursor sampleCursor = this.mediaInfoCursor.getSampleTableAtom().new SampleTableAtom.SampleCursor();
            sampleCursor.gotoSample(this.beginSampleNumber);
            this.mediaDataSize += sampleCursor.getSampleLength();
            while (sampleCursor.hasNextSample() && sampleCursor.getSampleNumber() < this.endSampleNumber) {
                sampleCursor.nextSample();
                this.mediaDataSize += sampleCursor.getSampleLength();
            }
        }

        private void targetSamples() {
            SampleTableAtom.SampleCursor sampleCursor = this.mediaInfoCursor.getSampleTableAtom().new SampleTableAtom.SampleCursor();
            if (!sampleCursor.gotoTime(this.mediaStart.getTimeValue())) {
                throw new IllegalStateException("Could not start at " + this.mediaStart);
            }
            this.beginSampleNumber = sampleCursor.getSampleNumber();
            this.beginSampleTimeOffset = this.mediaStart.getTimeValue() - sampleCursor.getSampleTime();
            if (!sampleCursor.gotoTime(this.mediaEnd.getTimeValue())) {
                throw new IllegalStateException("Could not end at " + this.mediaEnd);
            }
            this.endSampleNumber = sampleCursor.getSampleNumber();
            this.endSampleTimeOffset = this.mediaEnd.getTimeValue() - sampleCursor.getSampleTime();
        }

        public long getChunkLocation() {
            return this.location;
        }

        private void setChunkLocation(long location) {
            this.location = location;
        }

        public void writeMediaData(MovieOutputStream movieOutputStream) throws IOException {
            movieOutputStream.writeAtomHeader("mdat", this.mediaDataSize);
            this.setChunkLocation(movieOutputStream.getByteLength());
            SampleTableAtom.SampleCursor sampleCursor = this.mediaInfoCursor.getSampleTableAtom().new SampleTableAtom.SampleCursor();
            sampleCursor.gotoSample(this.beginSampleNumber);
            AtomInputStream atomInputStream = new AtomInputStream(this.seekableDataInput, sampleCursor);
            IOUtils.copy((InputStream)atomInputStream, (OutputStream)((Object)movieOutputStream));
            while (sampleCursor.hasNextSample() && sampleCursor.getSampleNumber() < this.endSampleNumber) {
                sampleCursor.nextSample();
                atomInputStream = new AtomInputStream(this.seekableDataInput, sampleCursor);
                IOUtils.copy((InputStream)atomInputStream, (OutputStream)((Object)movieOutputStream));
            }
        }

        public long getMediaDataSize() {
            return this.mediaDataSize;
        }

        public long getBeginSampleNumber() {
            return this.beginSampleNumber;
        }

        public long getBeginSampleTimeOffset() {
            return this.beginSampleTimeOffset;
        }

        public long getEndSampleNumber() {
            return this.endSampleNumber;
        }

        public long getEndSampleTimeOffset() {
            return this.endSampleTimeOffset;
        }
    }
}

