/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.TrackResult;
import com.apple.jingle.leghorn.quicktime.compare.xml.TrackList;
import com.apple.jingle.leghorn.quicktime.compare.xml.TrackRes;
import com.apple.jingle.leghorn.quicktime.compare.xml.TrackResultList;
import com.apple.jingle.leghorn.quicktime.compare.xml.TrackTypeRes;
import java.util.ArrayList;
import java.util.List;
import noNamespace.Track;

public class TrackTypeResult {
    private String name;
    private List<TrackResult> matchedTracks = new ArrayList<TrackResult>();
    private List<TrackResult> unmatchedTracks = new ArrayList<TrackResult>();
    private List<Track> extraTracksA = new ArrayList<Track>();
    private List<Track> extraTracksB = new ArrayList<Track>();

    public TrackTypeResult(String typeName) {
        this.name = typeName;
    }

    public String getName() {
        return this.name;
    }

    public List<TrackResult> getMatchedTracks() {
        return this.matchedTracks;
    }

    public List<TrackResult> getUnmatchedTracks() {
        return this.unmatchedTracks;
    }

    public List<Track> getExtraTracksA() {
        return this.extraTracksA;
    }

    public List<Track> getExtraTracksB() {
        return this.extraTracksB;
    }

    public void addMatchedTrack(TrackResult matchResult) {
        this.matchedTracks.add(matchResult);
    }

    public void addUnmatchedTrack(TrackResult matchResult) {
        this.unmatchedTracks.add(matchResult);
    }

    public void addExtraTrackA(Track t) {
        this.extraTracksA.add(t);
    }

    public void addExtraTrackB(Track t) {
        this.extraTracksB.add(t);
    }

    public String toString() {
        return "name=" + this.name + "; \n" + "matchedTracks=" + this.matchedTracks + "; \n" + "unmatchedTracks=" + this.unmatchedTracks + "; \n" + "extraTracksA =" + this.extraTracksA + "; \n" + "extraTracksB =" + this.extraTracksB + "; \n";
    }

    public void convertToXml(TrackTypeRes typeRes) {
        TrackRes trackRes;
        typeRes.setName(this.name);
        if (!this.matchedTracks.isEmpty()) {
            TrackResultList matched = typeRes.addNewMatchedTracks();
            for (TrackResult tr : this.matchedTracks) {
                trackRes = matched.addNewTrackResult();
                tr.convertToXml(trackRes);
            }
        }
        if (!this.unmatchedTracks.isEmpty()) {
            TrackResultList unmatched = typeRes.addNewUnmatchedTracks();
            for (TrackResult tr : this.unmatchedTracks) {
                trackRes = unmatched.addNewTrackResult();
                tr.convertToXml(trackRes);
            }
        }
        if (!this.extraTracksA.isEmpty()) {
            TrackList extraA = typeRes.addNewExtraTracksA();
            for (Track t : this.extraTracksA) {
                extraA.addTrack(t.getTrackId());
            }
        }
        if (!this.extraTracksB.isEmpty()) {
            TrackList extraB = typeRes.addNewExtraTracksB();
            for (Track t : this.extraTracksB) {
                extraB.addTrack(t.getTrackId());
            }
        }
    }
}

