/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import com.apple.jingle.leghorn.quicktime.compare.xml.CorrelatorList;
import com.apple.jingle.leghorn.quicktime.compare.xml.CorrelatorRes;
import com.apple.jingle.leghorn.quicktime.compare.xml.TrackRes;
import java.util.ArrayList;
import java.util.List;
import noNamespace.Track;

public class TrackResult {
    private Track trackA;
    private Track trackB;
    private boolean success;
    private List<CorrelatorResult> successResults = new ArrayList<CorrelatorResult>();
    private List<CorrelatorResult> failureResults = new ArrayList<CorrelatorResult>();

    public TrackResult(Track a, Track b) {
        this.trackA = a;
        this.trackB = b;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Track getTrackA() {
        return this.trackA;
    }

    public Track getTrackB() {
        return this.trackB;
    }

    public void addCorrelatorResult(CorrelatorResult result) {
        if (result.getSuccess()) {
            this.successResults.add(result);
        } else {
            this.failureResults.add(result);
        }
    }

    public int getFailureCount() {
        return this.failureResults.size();
    }

    public List<CorrelatorResult> getSuccessResults() {
        return this.successResults;
    }

    public List<CorrelatorResult> getFailureResults() {
        return this.failureResults;
    }

    public String toString() {
        return "trackA=" + this.trackA.getTrackId() + "; " + "trackB=" + this.trackB.getTrackId() + "; " + "success=" + this.success + "; " + "successResults =" + this.successResults + "; " + "failureResults =" + this.failureResults + "; \n";
    }

    public void convertToXml(TrackRes res) {
        CorrelatorRes corrRes;
        res.setSuccess(this.success);
        res.setTrackA(this.trackA.getTrackId());
        res.setTrackB(this.trackB.getTrackId());
        if (!this.successResults.isEmpty()) {
            CorrelatorList successes = res.addNewSuccessfulCorrelators();
            for (CorrelatorResult cr : this.successResults) {
                corrRes = successes.addNewCorrelator();
                cr.convertToXml(corrRes);
            }
        }
        if (!this.failureResults.isEmpty()) {
            CorrelatorList failures = res.addNewFailedCorrelators();
            for (CorrelatorResult cr : this.failureResults) {
                corrRes = failures.addNewCorrelator();
                cr.convertToXml(corrRes);
            }
        }
    }
}

