/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import com.apple.jingle.leghorn.quicktime.compare.QuickTimeComparer;
import com.apple.jingle.leghorn.quicktime.compare.TrackResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import noNamespace.Track;
import noNamespace.TrackReference;

public class TrackReferenceCorrelator
extends Correlator {
    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        CorrelatorResult result = CorrelatorResult.success(trackA, trackB, this);
        TrackReference[] refsA = trackA.getTrackReferenceArray();
        TrackReference[] refsB = trackB.getTrackReferenceArray();
        QuickTimeComparer comparer = this.getCorrelationModel().getComparer();
        if (refsA.length != refsB.length) {
            String explanation = String.format("Number of track references does not match (%s vs %s)", refsA.length, refsB.length);
            result = CorrelatorResult.failure(trackA, trackB, this, explanation);
        } else {
            for (TrackReference tr : refsA) {
                String refType = tr.getType();
                BigInteger refId = tr.getBigIntegerValue();
                Track refTrack = comparer.findTrackById(refId, comparer.getTrackMapA());
                List<Track> candidates = this.findReferencedTracksByType(refType, refsB, this.getCorrelationModel().getComparer().getTrackMapB());
                ArrayList<Correlator> ignore = new ArrayList<Correlator>();
                ignore.add(this);
                TrackResult matchResult = this.getCorrelationModel().bestMatch(refTrack, candidates, ignore);
                if (matchResult == null) {
                    result = CorrelatorResult.failure(trackA, trackB, this, String.format("TrackReference match failed.  No tracks of type %s found", refType));
                    continue;
                }
                if (matchResult.getSuccess()) continue;
                if (result.getSuccess()) {
                    result = CorrelatorResult.failure(trackA, trackB, this, "TrackReference match failed.");
                }
                CorrelatorResult subFailure = CorrelatorResult.failure(trackA, trackB, this, String.format("TrackReference id %s type %s failed to match track_id %s.", refId, refType, matchResult.getTrackB().getTrackId()));
                result.addNestedResult(subFailure);
                subFailure.getNestedResults().addAll(matchResult.getFailureResults());
            }
        }
        return result;
    }

    private List<Track> findReferencedTracksByType(String type, TrackReference[] otherRefs, Map<String, List<Track>> otherTracks) {
        ArrayList<Track> others = new ArrayList<Track>();
        for (TrackReference tr : otherRefs) {
            String otherType = tr.getType();
            if (!type.equals(otherType)) continue;
            BigInteger id = tr.getBigIntegerValue();
            Track otherTrack = this.getCorrelationModel().getComparer().findTrackById(id, otherTracks);
            if (otherTrack == null) continue;
            others.add(otherTrack);
        }
        return others;
    }
}

