/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SyncSampleAtom;
import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import java.util.List;
import noNamespace.Track;

public class SyncSampleCorrelator
extends Correlator {
    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        MediaDescriptionGenerator.TrackAtoms taA = this.getTrackAtoms(this.getCorrelationModel().getComparer().getQtfA(), trackA);
        MediaDescriptionGenerator.TrackAtoms taB = this.getTrackAtoms(this.getCorrelationModel().getComparer().getQtfB(), trackB);
        if (taA == null || taB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        SampleTableAtom stblA = taA.stblAtom;
        SampleTableAtom stblB = taB.stblAtom;
        if (stblA == null || stblB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        SyncSampleAtom stssA = stblA.findSingleChildOfType(SyncSampleAtom.class, false, false);
        SyncSampleAtom stssB = stblB.findSingleChildOfType(SyncSampleAtom.class, false, false);
        if (stssA == null && stssB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        long notMatched = 0L;
        long samplesA = 0L;
        long samplesB = 0L;
        if (stssA == null || stssB == null) {
            long i;
            List<Long> syncSamples;
            long totalSamples = 0L;
            if (stssA == null) {
                syncSamples = stssB.getSyncSamples();
                if (taA.stszAtom != null) {
                    totalSamples = taA.stszAtom.getSampleCount();
                }
                samplesA = totalSamples;
                samplesB = syncSamples.size();
            } else {
                syncSamples = stssA.getSyncSamples();
                if (taB.stszAtom != null) {
                    totalSamples = taB.stszAtom.getSampleCount();
                }
                samplesB = totalSamples;
                samplesA = syncSamples.size();
            }
            for (i = 0L; i < totalSamples; ++i) {
                if (i >= (long)syncSamples.size()) {
                    notMatched += totalSamples - (long)syncSamples.size();
                    break;
                }
                Long sync = syncSamples.get((int)i);
                if (sync == i) continue;
                ++notMatched;
            }
            if (i < (long)syncSamples.size()) {
                notMatched += (long)syncSamples.size() - i;
            }
        } else {
            List<Long> syncSamplesA = stssA.getSyncSamples();
            List<Long> syncSamplesB = stssB.getSyncSamples();
            samplesA = syncSamplesA.size();
            samplesB = syncSamplesB.size();
            int i = 0;
            while ((long)i < samplesA && (long)i < samplesB) {
                if (!syncSamplesA.get(i).equals(syncSamplesB.get(i))) {
                    ++notMatched;
                }
                ++i;
            }
            if (samplesA != samplesB) {
                notMatched += Math.abs(samplesA - samplesB);
            }
        }
        if (notMatched != 0L) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Sync samples do not match. Sync samples: %s vs %s. Samples not matching: %s (%.1f %%)");
            result.addArgument("sampleCount.A", samplesA);
            result.addArgument("sampleCount.B", samplesB);
            result.addArgument("notMatched", notMatched);
            result.addArgument("percentage", 100.0 * (double)notMatched / (double)Math.min(samplesA, samplesB));
            return result;
        }
        return CorrelatorResult.success(trackA, trackB, this);
    }
}

