/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import noNamespace.Channel;
import noNamespace.ChannelLayout;
import noNamespace.SoundTrack;
import noNamespace.Track;
import org.apache.xmlbeans.XmlObject;

public class SoundChannelCorrelator
extends Correlator {
    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        Channel[] chB;
        if (!(trackA instanceof SoundTrack) || !(trackB instanceof SoundTrack)) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        SoundTrack stA = (SoundTrack)trackA;
        SoundTrack stB = (SoundTrack)trackB;
        ChannelLayout clA = stA.getChannelLayout();
        ChannelLayout clB = stB.getChannelLayout();
        if (!clA.getName().equals(clB.getName())) {
            String explanation = String.format("ChannelLayout name %s does not match %s", clA.getName(), clB.getName());
            return CorrelatorResult.failure(trackA, trackB, this, explanation);
        }
        Channel[] chA = clA.getChannelArray();
        if (chA.length != (chB = clB.getChannelArray()).length) {
            String explanation = String.format("Channel count %s does not match %s", chA.length, chB.length);
            return CorrelatorResult.failure(trackA, trackB, this, explanation);
        }
        for (int i = 0; i < chA.length; ++i) {
            if (chA[i].valueEquals((XmlObject)chB[i])) continue;
            String explanation = String.format("Channel %s %s does not match %s", i, chA[i], chB[i]);
            return CorrelatorResult.failure(trackA, trackB, this, explanation);
        }
        return CorrelatorResult.success(trackA, trackB, this);
    }
}

