/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import com.apple.jingle.leghorn.quicktime.compare.Range;
import java.util.LinkedHashSet;
import noNamespace.Track;

public class SampleSizeCorrelator
extends Correlator {
    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        MediaDescriptionGenerator.TrackAtoms taA = this.getTrackAtoms(this.getCorrelationModel().getComparer().getQtfA(), trackA);
        MediaDescriptionGenerator.TrackAtoms taB = this.getTrackAtoms(this.getCorrelationModel().getComparer().getQtfB(), trackB);
        if (taA == null || taB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        SampleSizeAtom stszA = taA.stszAtom;
        SampleSizeAtom stszB = taB.stszAtom;
        if (stszA == null && stszB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        if (stszA == null && stszB != null || stszA != null && stszB == null) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Sample sizes do not match, one track missing stsz atom: %s vs %s ");
            result.addArgument("stsz.A", stszA);
            result.addArgument("stsz.B", stszB);
            return result;
        }
        long notMatched = 0L;
        LinkedHashSet<Range> mismatchedSamples = new LinkedHashSet<Range>();
        Range range = null;
        if (stszA.getGlobalSampleSize() != 0L && stszB.getGlobalSampleSize() != 0L) {
            if (stszA.getGlobalSampleSize() != stszB.getGlobalSampleSize()) {
                notMatched = Math.max(stszA.getSampleCount(), stszB.getSampleCount());
            }
        } else {
            for (long i = 1L; i <= stszA.getSampleCount() && i <= stszB.getSampleCount(); ++i) {
                if (stszA.getSampleSize(i) == stszB.getSampleSize(i)) continue;
                ++notMatched;
                range = range == null ? new Range(i, i) : range.add(i);
                mismatchedSamples.add(range);
            }
        }
        if (stszA.getSampleCount() != stszB.getSampleCount()) {
            notMatched += Math.abs(stszA.getSampleCount() - stszB.getSampleCount());
        }
        if (notMatched != 0L) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Sample sizes do not match. Sample counts: %s vs %s. Samples not matching: %s (%.1f %%).  Mismatched Samples: %s.");
            result.addArgument("sampleCount.A", stszA.getSampleCount());
            result.addArgument("sampleCount.B", stszB.getSampleCount());
            result.addArgument("notMatched", notMatched);
            result.addArgument("percentage", 100.0 * (double)notMatched / (double)Math.min(stszA.getSampleCount(), stszB.getSampleCount()));
            result.addArgument("mismatchedSamples", mismatchedSamples);
            return result;
        }
        return CorrelatorResult.success(trackA, trackB, this);
    }
}

