/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import java.util.List;
import noNamespace.Track;

public class SampleDurationCorrelator
extends Correlator {
    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        MediaDescriptionGenerator.TrackAtoms taA = this.getTrackAtoms(this.getCorrelationModel().getComparer().getQtfA(), trackA);
        MediaDescriptionGenerator.TrackAtoms taB = this.getTrackAtoms(this.getCorrelationModel().getComparer().getQtfB(), trackB);
        if (taA == null || taB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        SampleTableAtom stblA = taA.stblAtom;
        SampleTableAtom stblB = taB.stblAtom;
        if (stblA == null || stblB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        SampleToTimeAtom sttsA = stblA.findSingleChildOfType(SampleToTimeAtom.class, false, false);
        SampleToTimeAtom sttsB = stblB.findSingleChildOfType(SampleToTimeAtom.class, false, false);
        if (sttsA == null && sttsB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        if (sttsA == null && sttsB != null || sttsA != null && sttsB == null) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Sample durations do not match, one track missing stts atom: %s vs %s ");
            result.addArgument("stts.A", sttsA);
            result.addArgument("stts.B", sttsB);
            return result;
        }
        long notMatched = 0L;
        long samplesA = 0L;
        long samplesB = 0L;
        List<SampleToTimeAtom.TableEntry> durationsA = sttsA.getCountToTimeTable();
        List<SampleToTimeAtom.TableEntry> durationsB = sttsB.getCountToTimeTable();
        if (durationsA.size() == 1 && durationsB.size() == 1) {
            SampleToTimeAtom.TableEntry teA = durationsA.get(0);
            SampleToTimeAtom.TableEntry teB = durationsB.get(0);
            samplesA = teA.getSampleCount();
            samplesB = teB.getSampleCount();
            if (teA.getSampleDuration() != teB.getSampleDuration()) {
                notMatched = Math.min(samplesA, samplesB);
            }
        } else {
            SttsCursor cursorB = new SttsCursor(sttsB);
            for (SampleToTimeAtom.TableEntry te : durationsA) {
                long cnt = te.getSampleCount();
                long durA = te.getSampleDuration();
                int i = 0;
                while ((long)i < cnt) {
                    long durB = cursorB.nextSampleDuration();
                    if (durA != durB) {
                        ++notMatched;
                    }
                    ++samplesA;
                    if (!cursorB.beyondTable) {
                        ++samplesB;
                    }
                    ++i;
                }
            }
            cursorB.nextSampleDuration();
            while (!cursorB.beyondTable) {
                ++notMatched;
                ++samplesB;
                cursorB.nextSampleDuration();
            }
        }
        if (notMatched != 0L) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Sample durations do not match. Sample counts: %s vs %s. Samples not matching: %s (%.1f %%)");
            result.addArgument("sampleCount.A", samplesA);
            result.addArgument("sampleCount.B", samplesB);
            result.addArgument("notMatched", notMatched);
            result.addArgument("percentage", 100.0 * (double)notMatched / (double)Math.min(samplesA, samplesB));
            return result;
        }
        return CorrelatorResult.success(trackA, trackB, this);
    }

    private static class SttsCursor {
        private List<SampleToTimeAtom.TableEntry> durations;
        private SampleToTimeAtom.TableEntry currentEntry;
        private long sampleIdx;
        private int listIdx;
        public boolean beyondTable = false;

        public SttsCursor(SampleToTimeAtom stts) {
            this.durations = stts.getCountToTimeTable();
            this.currentEntry = this.durations.isEmpty() ? new SampleToTimeAtom.TableEntry() : this.durations.get(0);
        }

        public long nextSampleDuration() {
            long result = -1L;
            if (this.beyondTable) {
                return result;
            }
            if (this.sampleIdx < this.currentEntry.getSampleCount()) {
                result = this.currentEntry.getSampleDuration();
            } else {
                ++this.listIdx;
                if (this.listIdx < this.durations.size()) {
                    this.currentEntry = this.durations.get(this.listIdx);
                    this.sampleIdx = 0L;
                    result = this.currentEntry.getSampleDuration();
                } else {
                    this.beyondTable = true;
                }
            }
            ++this.sampleIdx;
            return result;
        }
    }
}

