/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import java.io.IOException;
import java.util.Arrays;
import noNamespace.Track;
import org.apache.log4j.Logger;

public class SampleBytesCorrelator
extends Correlator {
    private static Logger logger = Logger.getLogger(SampleBytesCorrelator.class);
    public long tot;
    public long sc;
    public long ba;
    public long br;
    public long bc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        this.tot = 0L;
        this.sc = 0L;
        this.ba = 0L;
        this.br = 0L;
        this.bc = 0L;
        long totStart = System.currentTimeMillis();
        MediaDescriptionGenerator.TrackAtoms taA = this.getTrackAtoms(this.getCorrelationModel().getComparer().getQtfA(), trackA);
        MediaDescriptionGenerator.TrackAtoms taB = this.getTrackAtoms(this.getCorrelationModel().getComparer().getQtfB(), trackB);
        if (taA == null) return CorrelatorResult.success(trackA, trackB, this);
        if (taB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        SampleTableAtom stblA = taA.stblAtom;
        SampleTableAtom stblB = taB.stblAtom;
        if (stblA == null && stblB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        if (stblA == null && stblB != null || stblA != null && stblB == null) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Cannot compare sample bytes, one track missing stbl atom: %s vs %s ");
            result.addArgument("stsz.A", stblA);
            result.addArgument("stsz.B", stblB);
            return result;
        }
        SampleSizeAtom stszA = taA.stszAtom;
        SampleSizeAtom stszB = taB.stszAtom;
        if (stszA != null && stszB != null && stszA.getSampleCount() != stszB.getSampleCount()) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Sample counts do not match: %s vs %s ");
            result.addArgument("sampleCount.A", stszA.getSampleCount());
            result.addArgument("sampleCount.B", stszB.getSampleCount());
            return result;
        }
        SampleTableAtom.SampleCursor curA = stblA.new SampleTableAtom.SampleCursor();
        SampleTableAtom.SampleCursor curB = stblB.new SampleTableAtom.SampleCursor();
        try {
            FileSeekableDataInput sdiA = new FileSeekableDataInput(this.getCorrelationModel().getComparer().getFileA());
            FileSeekableDataInput sdiB = new FileSeekableDataInput(this.getCorrelationModel().getComparer().getFileB());
            try {
                boolean aHasSample = curA.nextSample();
                while (aHasSample) {
                    boolean success = true;
                    long scStart = System.currentTimeMillis();
                    curB.nextSample();
                    this.sc += System.currentTimeMillis() - scStart;
                    if (curA.getSampleLength() == curB.getSampleLength()) {
                        long baStart = System.currentTimeMillis();
                        byte[] bytesA = new byte[(int)curA.getSampleLength()];
                        byte[] bytesB = new byte[(int)curB.getSampleLength()];
                        this.ba += System.currentTimeMillis() - baStart;
                        long brStart = System.currentTimeMillis();
                        sdiA.seek(curA.getSamplePosition());
                        sdiB.seek(curB.getSamplePosition());
                        sdiA.readFully(bytesA);
                        sdiB.readFully(bytesB);
                        this.br += System.currentTimeMillis() - brStart;
                        long bcStart = System.currentTimeMillis();
                        if (!Arrays.equals(bytesA, bytesB)) {
                            success = false;
                        }
                        this.bc += System.currentTimeMillis() - bcStart;
                    } else {
                        success = false;
                    }
                    if (!success) {
                        CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Sample bytes do not match for sample %s, size %s vs %s");
                        result.addArgument("sampleNumber.A", curA.getSampleNumber());
                        result.addArgument("sampleSize.A", curA.getSampleLength());
                        result.addArgument("sampleSize.B", curB.getSampleLength());
                        CorrelatorResult correlatorResult = result;
                        return correlatorResult;
                    }
                    scStart = System.currentTimeMillis();
                    aHasSample = curA.nextSample();
                    this.sc += System.currentTimeMillis() - scStart;
                }
            }
            finally {
                try {
                    sdiA.close();
                }
                catch (Exception ignored) {}
                try {
                    sdiB.close();
                }
                catch (Exception ignored) {}
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Sample byte comparison failed", (Throwable)ioe);
            return CorrelatorResult.failure(trackA, trackB, this, "Exception during sample byte compare " + ioe);
        }
        this.tot += System.currentTimeMillis() - totStart;
        if (!logger.isDebugEnabled()) return CorrelatorResult.success(trackA, trackB, this);
        return CorrelatorResult.success(trackA, trackB, this);
    }
}

