/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.MPEG4Parser;
import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.leghorn.quicktime.compare.ComparerResult;
import com.apple.jingle.leghorn.quicktime.compare.CorrelationModel;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import com.apple.jingle.leghorn.quicktime.compare.TrackResult;
import com.apple.jingle.leghorn.quicktime.compare.TrackTypeResult;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import noNamespace.MovieDocument;
import noNamespace.Track;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.Node;

public class QuickTimeComparer {
    private static Logger logger = Logger.getLogger(QuickTimeComparer.class);
    private Pattern trackGetterPattern = Pattern.compile("^get(.+)Array$");
    private File fileA;
    private File fileB;
    private MovieDocument movDocA;
    private MovieDocument movDocB;
    private QuickTimeFile qtfA;
    private QuickTimeFile qtfB;
    private Map<String, List<Track>> trackMapA;
    private Map<String, List<Track>> trackMapB;
    private CorrelationModel correlationModel = new CorrelationModel();
    private boolean printOutput = true;

    public QuickTimeComparer() {
        this.correlationModel.setComparer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String correlationSpec, File fileA, File fileB) throws Exception {
        this.fileA = fileA;
        this.fileB = fileB;
        this.correlationModel.parse(correlationSpec);
        QuickTimeValidationContext ctxA = new QuickTimeValidationContext(fileA.getName());
        QuickTimeValidationContext ctxB = new QuickTimeValidationContext(fileB.getName());
        if (fileA.getName().endsWith(".xml") && fileB.getName().endsWith(".xml")) {
            this.movDocA = MovieDocument.Factory.parse((String)QuickTimeComparer.readAsString(fileA));
            this.movDocB = MovieDocument.Factory.parse((String)QuickTimeComparer.readAsString(fileB));
        } else {
            URI fileA_URI = fileA.toURI();
            URI fileB_URI = fileB.toURI();
            SeekableDataInput qtfASDI = SeekableDataInput.Factory.fromURI((URI)fileA_URI);
            SeekableDataInput qtfBSDI = SeekableDataInput.Factory.fromURI((URI)fileB_URI);
            try {
                this.qtfA = this.parseMovie(ctxA, qtfASDI, fileA_URI);
                this.qtfB = this.parseMovie(ctxB, qtfBSDI, fileB_URI);
                this.movDocA = MediaDescriptionGenerator.generateDescription(ctxA, this.qtfA);
                this.movDocB = MediaDescriptionGenerator.generateDescription(ctxB, this.qtfB);
            }
            finally {
                qtfASDI.close();
                qtfBSDI.close();
            }
        }
    }

    private QuickTimeFile parseMovie(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi, URI uri) throws IOException {
        BaseParser parser;
        String fileArgument = uri.getPath();
        if (fileArgument.endsWith(".mov")) {
            parser = new QuickTimeParser();
        } else if (fileArgument.endsWith(".m4v") || fileArgument.endsWith(".mp4")) {
            parser = new MPEG4Parser();
        } else {
            throw new RuntimeException("Could not determine parser to use based on file extension: " + fileArgument);
        }
        QuickTimeFile qtf = parser.parseFile(ctx, sdi);
        return qtf;
    }

    private QuickTimeFile parseMovie(@Nonnull LeghornValidationContext ctx, File file) throws IOException {
        BaseParser parser;
        String fileArgument = file.getName();
        if (fileArgument.endsWith(".mov")) {
            parser = new QuickTimeParser();
        } else if (fileArgument.endsWith(".m4v") || fileArgument.endsWith(".mp4")) {
            parser = new MPEG4Parser();
        } else {
            throw new RuntimeException("Could not determine parser to use based on file extension: " + fileArgument);
        }
        QuickTimeFile qtf = parser.parseFile(ctx, file);
        return qtf;
    }

    public void output(Object o) {
        this.output(0, o);
    }

    public void output(int indent, Object o) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        if (this.printOutput) {
            System.out.println(sb.toString() + o);
        }
    }

    public Map<String, List<Track>> getAllTracks(MovieDocument.Movie.Tracks movieTracks) throws Exception {
        Method[] methods;
        TreeMap<String, List<Track>> results = new TreeMap<String, List<Track>>();
        for (Method m : methods = movieTracks.getClass().getMethods()) {
            String mname = m.getName();
            Matcher matcher = this.trackGetterPattern.matcher(mname);
            if (!matcher.matches() || m.getParameterTypes().length != 0) continue;
            String trackTypeName = matcher.group(1);
            Object obj = m.invoke((Object)movieTracks, new Object[0]);
            if (!(obj instanceof Track[])) continue;
            Track[] tracks = (Track[])obj;
            results.put(trackTypeName, Arrays.asList(tracks));
        }
        return results;
    }

    public Track findTrackById(BigInteger id, Map<String, List<Track>> trackMap) {
        for (List<Track> tracks : trackMap.values()) {
            for (Track track : tracks) {
                if (!track.getTrackId().equals(id)) continue;
                return track;
            }
        }
        return null;
    }

    public ComparerResult compare() throws Exception {
        ComparerResult result = new ComparerResult(true, this.fileA, this.fileB);
        this.trackMapA = this.getAllTracks(this.movDocA.getMovie().getTracks());
        this.trackMapB = this.getAllTracks(this.movDocB.getMovie().getTracks());
        Collections.sort(this.correlationModel.correlatorNames);
        this.output("Correlators used: " + this.correlationModel.correlatorNames);
        for (Map.Entry<String, List<Track>> e : this.trackMapA.entrySet()) {
            TrackResult matchResult;
            Track trackA;
            Object t;
            String currentTrackType = e.getKey();
            List<Track> currentTrackList = e.getValue();
            ArrayList<Track> candidates = new ArrayList<Track>((Collection)this.trackMapB.get(currentTrackType));
            TrackTypeResult trackTypeResult = new TrackTypeResult(currentTrackType);
            if (currentTrackList.isEmpty() && candidates.isEmpty()) continue;
            this.output(currentTrackType + " tracks:");
            this.output(1, String.format("%s has %s.  %s has %s.", this.fileA.getName(), currentTrackList.size(), this.fileB.getName(), candidates.size()));
            ArrayList<Track> notMatchedTracksA = new ArrayList<Track>();
            Iterator<Object> i$ = currentTrackList.iterator();
            while (i$.hasNext()) {
                trackA = t = i$.next();
                if (candidates.isEmpty()) {
                    notMatchedTracksA.add(trackA);
                    result.setSuccess(false);
                    continue;
                }
                matchResult = this.correlationModel.bestMatch(trackA, candidates, Collections.emptyList());
                if (matchResult.getSuccess()) {
                    trackTypeResult.addMatchedTrack(matchResult);
                    this.output(1, String.format("matched track_id %s to track_id %s", trackA.getTrackId(), matchResult.getTrackB().getTrackId()));
                    candidates.remove(matchResult.getTrackB());
                    continue;
                }
                notMatchedTracksA.add(trackA);
                result.setSuccess(false);
            }
            i$ = notMatchedTracksA.iterator();
            while (i$.hasNext()) {
                trackA = t = i$.next();
                if (candidates.isEmpty()) {
                    trackTypeResult.addExtraTrackA(trackA);
                    this.output(1, String.format("%s has extra track (track_id %s)", this.fileA.getName(), trackA.getTrackId()));
                    continue;
                }
                matchResult = this.correlationModel.bestMatch(trackA, candidates, Collections.emptyList());
                trackTypeResult.addUnmatchedTrack(matchResult);
                this.output(1, String.format("no match for track_id %s.  closest match track_id %s", trackA.getTrackId(), matchResult.getTrackB().getTrackId()));
                this.outputCorrelatorResults(3, matchResult.getFailureResults());
                candidates.remove(matchResult.getTrackB());
            }
            if (!candidates.isEmpty()) {
                result.setSuccess(false);
                i$ = candidates.iterator();
                while (i$.hasNext()) {
                    Object trackB = t = i$.next();
                    trackTypeResult.addExtraTrackB((Track)trackB);
                    this.output(1, String.format("%s has extra track (track_id %s)", this.fileB.getName(), trackB.getTrackId()));
                }
            }
            result.addTrackTypeResult(trackTypeResult);
        }
        this.output("");
        if (result.getSuccess()) {
            this.output(String.format("%s matches %s", this.fileA.getName(), this.fileB.getName()));
        } else {
            this.output(String.format("%s does not match %s", this.fileA.getName(), this.fileB.getName()));
        }
        this.output("");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n" + XMLUtil.nodeToString((Node)result.convertToXml())));
        }
        return result;
    }

    public void outputCorrelatorResults(int startIndent, List<CorrelatorResult> results) {
        for (CorrelatorResult cr : results) {
            this.output(startIndent, cr);
            List<CorrelatorResult> childResults = cr.getNestedResults();
            if (childResults.isEmpty()) continue;
            this.outputCorrelatorResults(startIndent + 1, childResults);
        }
    }

    public static String readAsString(File f) throws IOException {
        int c;
        StringWriter sw = new StringWriter();
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((c = br.read()) != -1) {
            sw.write(c);
        }
        br.close();
        sw.flush();
        return sw.toString();
    }

    public Map<String, List<Track>> getTrackMapA() {
        return this.trackMapA;
    }

    public Map<String, List<Track>> getTrackMapB() {
        return this.trackMapB;
    }

    public QuickTimeFile getQtfA() {
        return this.qtfA;
    }

    public QuickTimeFile getQtfB() {
        return this.qtfB;
    }

    public File getFileA() {
        return this.fileA;
    }

    public File getFileB() {
        return this.fileB;
    }

    public boolean getPrintOutput() {
        return this.printOutput;
    }

    public void setPrintOutput(boolean printOutput) {
        this.printOutput = printOutput;
    }

    public static void main(String[] args) throws Exception {
        File logConfFile = new File("log.conf");
        if (logConfFile.exists()) {
            PropertyConfigurator.configure((String)logConfFile.getAbsolutePath());
        }
        File fileA = new File(args[0]);
        File fileB = new File(args[1]);
        String correlationSpec = args[2];
        boolean outputXml = false;
        if (args.length > 3 && "xml".equals(args[3])) {
            outputXml = true;
        }
        QuickTimeComparer qtc = new QuickTimeComparer();
        if (outputXml) {
            qtc.setPrintOutput(false);
        }
        qtc.init(correlationSpec, fileA, fileB);
        ComparerResult result = qtc.compare();
        if (outputXml) {
            Node xmlNode = result.convertToXml();
            System.out.println(XMLUtil.nodeToString((Node)xmlNode));
        }
    }
}

