/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import noNamespace.Language;
import noNamespace.Track;
import org.apache.xmlbeans.XmlObject;

public class LanguageCorrelator
extends Correlator {
    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        Language lanA = trackA.getLanguage();
        Language lanB = trackB.getLanguage();
        if (lanA == null && lanB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        if (lanA == null || lanB == null) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Language %s does not match %s");
            result.addArgument("language.A", lanA);
            result.addArgument("language.B", lanB);
            return result;
        }
        if (lanA.valueEquals((XmlObject)lanB)) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Language '%s' (%s) does not match '%s' (%s)");
        result.addArgument("language.A", lanA.getStringValue());
        result.addArgument("numeric.A", lanA.getNumeric());
        result.addArgument("language.B", lanB.getStringValue());
        result.addArgument("numeric.B", lanB.getNumeric());
        return result;
    }
}

