/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import noNamespace.ExtendedLanguage;
import noNamespace.Track;
import org.apache.xmlbeans.XmlObject;

public class ExtendedLanguageCorrelator
extends Correlator {
    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        ExtendedLanguage lanA = trackA.getExtendedLanguage();
        ExtendedLanguage lanB = trackB.getExtendedLanguage();
        if (lanA == null && lanB == null) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        if (lanA == null || lanB == null) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Extended Language %s does not match %s");
            result.addArgument("language.A", lanA != null ? lanA.getStringValue() : null);
            result.addArgument("language.B", lanB != null ? lanB.getStringValue() : null);
            return result;
        }
        if (lanA.valueEquals((XmlObject)lanB)) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "Extended Language '%s' does not match '%s'");
        result.addArgument("language.A", lanA.getStringValue());
        result.addArgument("language.B", lanB.getStringValue());
        return result;
    }
}

