/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.xml.Argument;
import com.apple.jingle.leghorn.quicktime.compare.xml.CorrelatorList;
import com.apple.jingle.leghorn.quicktime.compare.xml.CorrelatorRes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.Track;

public class CorrelatorResult {
    private boolean success;
    private Track trackA;
    private Track trackB;
    private Correlator correlator;
    private String explanation;
    private Map<String, Object> arguments = new LinkedHashMap<String, Object>();
    private List<CorrelatorResult> nestedResults = new ArrayList<CorrelatorResult>();

    private CorrelatorResult(boolean success, Track a, Track b, Correlator c, String reason) {
        this.success = success;
        this.trackA = a;
        this.trackB = b;
        this.correlator = c;
        this.explanation = reason;
    }

    public static CorrelatorResult success(Track trackA, Track trackB, Correlator c) {
        return new CorrelatorResult(true, trackA, trackB, c, null);
    }

    public static CorrelatorResult failure(Track trackA, Track trackB, Correlator c, String explanation) {
        return new CorrelatorResult(false, trackA, trackB, c, explanation);
    }

    public String toString() {
        return this.formatExplanation();
    }

    public String formatExplanation() {
        if (this.trackA != null && this.trackB != null) {
            String formattedExp = String.format(this.explanation, this.arguments.values().toArray());
            return String.format("track_id %s vs track_id %s: %s", this.trackA.getTrackId(), this.trackB.getTrackId(), formattedExp);
        }
        if (this.explanation != null) {
            return this.explanation;
        }
        return ": No explanation available";
    }

    public void addArgument(String key, Object value) {
        this.arguments.put(key, value);
    }

    public void addNestedResult(CorrelatorResult cr) {
        this.nestedResults.add(cr);
    }

    public boolean getSuccess() {
        return this.success;
    }

    public Track getTrackA() {
        return this.trackA;
    }

    public Track getTrackB() {
        return this.trackB;
    }

    public Correlator getCorrelator() {
        return this.correlator;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public List<CorrelatorResult> getNestedResults() {
        return this.nestedResults;
    }

    public void convertToXml(CorrelatorRes res) {
        res.setSuccess(this.success);
        res.setTrackA(this.trackA.getTrackId());
        res.setTrackB(this.trackB.getTrackId());
        res.setName(this.correlator.getName());
        if (this.explanation != null) {
            res.setFormattedExplanation(this.formatExplanation());
            res.setExplanation(this.explanation);
            if (!this.arguments.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.arguments.entrySet()) {
                    Argument arg = res.addNewArgument();
                    arg.setName(String.valueOf(entry.getKey()));
                    arg.setStringValue(String.valueOf(entry.getValue()));
                }
            }
        }
        if (!this.nestedResults.isEmpty()) {
            CorrelatorList nested = res.addNewNestedFailures();
            for (CorrelatorResult cr : this.nestedResults) {
                CorrelatorRes corrRes = nested.addNewCorrelator();
                cr.convertToXml(corrRes);
            }
        }
    }
}

