/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.compare.CorrelationModel;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import com.apple.jingle.leghorn.quicktime.compare.XpathCompareFunctor;
import noNamespace.Track;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public abstract class Correlator {
    private static Logger logger = Logger.getLogger(Correlator.class);
    private CorrelationModel correlationModel;

    public CorrelationModel getCorrelationModel() {
        return this.correlationModel;
    }

    public void setCorrelationModel(CorrelationModel correlationModel) {
        this.correlationModel = correlationModel;
    }

    public abstract CorrelatorResult compare(Track var1, Track var2);

    public CorrelatorResult xpathCompare(String testName, Track trackA, Track trackB, String xpath) {
        return this.xpathCompare(testName, trackA, trackB, xpath, null);
    }

    public CorrelatorResult xpathCompare(String testName, Track trackA, Track trackB, String xpath, XpathCompareFunctor comparer) {
        XmlObject[] objsA = trackA.selectPath(xpath);
        XmlObject[] objsB = trackB.selectPath(xpath);
        if (objsA.length == 0 && objsB.length == 0) {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        if (objsA.length != objsB.length) {
            CorrelatorResult result = CorrelatorResult.failure(trackA, trackB, this, "%s compare failed, number of elements at %s do not match, %s versus %s");
            result.addArgument("testName", testName);
            result.addArgument("xpath", xpath);
            result.addArgument("numElements.A", objsA.length);
            result.addArgument("numElements.B", objsB.length);
            return result;
        }
        CorrelatorResult result = CorrelatorResult.success(trackA, trackB, this);
        for (int i = 0; i < objsA.length; ++i) {
            boolean isEqual = comparer != null ? comparer.compare(objsA[i], objsB[i]) : objsA[i].xmlText().equals(objsB[i].xmlText());
            if (!isEqual) {
                result = CorrelatorResult.failure(trackA, trackB, this, "%s compare failed, %s does not match %s");
                result.addArgument("testName", testName);
                result.addArgument(xpath + ".A", this.cleanString(objsA[i]));
                result.addArgument(xpath + ".B", this.cleanString(objsB[i]));
                break;
            }
            logger.debug((Object)(testName + " " + objsA[i] + " " + objsB[i]));
        }
        return result;
    }

    private String cleanString(Object input) {
        String result = input.toString().replace("\n", "");
        result = result.replace("<xml-fragment>", "");
        result = result.replace("</xml-fragment>", "");
        result = result.replace(" ", "");
        return result;
    }

    public MediaDescriptionGenerator.TrackAtoms getTrackAtoms(QuickTimeFile qtf, Track track) {
        MediaDescriptionGenerator.TrackAtoms ta = null;
        if (qtf != null) {
            ta = qtf.getTrackAtomMap().get(track.getTrackId());
        }
        return ta;
    }

    public String getName() {
        String className = this.getClass().getName();
        try {
            className = className.substring(className.lastIndexOf(46) + 1, className.lastIndexOf("Correlator"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return className;
    }
}

