/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import com.apple.jingle.leghorn.quicktime.compare.QuickTimeComparer;
import com.apple.jingle.leghorn.quicktime.compare.TrackResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import noNamespace.Track;
import org.apache.log4j.Logger;

public class CorrelationModel {
    private static Logger logger = Logger.getLogger(CorrelationModel.class);
    protected static final String CORRELATOR_NAME_SUFFIX = "Correlator";
    private QuickTimeComparer comparer;
    private List<Correlator> correlators = new ArrayList<Correlator>();
    protected List<String> correlatorNames = new ArrayList<String>();

    public void parse(String spec) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.correlators.clear();
        Package p = this.getClass().getPackage();
        String[] classNames = spec.split(",");
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>(Arrays.asList(classNames));
        for (String n : nameSet) {
            if ((n = n.trim()).length() <= 0) continue;
            this.correlatorNames.add(n);
            Class<?> c = Class.forName(p.getName() + "." + n + CORRELATOR_NAME_SUFFIX);
            Correlator correlator = (Correlator)c.newInstance();
            correlator.setCorrelationModel(this);
            this.correlators.add(correlator);
        }
    }

    public TrackResult bestMatch(Track trackA, List<Track> candidates, List<Correlator> ignore) {
        TrackResult bestResult = null;
        for (Track t : candidates) {
            Track candidateTrack = t;
            TrackResult result = this.matchTracks(trackA, candidateTrack, ignore);
            if (result.getSuccess()) {
                bestResult = result;
                break;
            }
            if (bestResult != null && bestResult.getFailureCount() <= result.getFailureCount()) continue;
            bestResult = result;
        }
        return bestResult;
    }

    private TrackResult matchTracks(Track trackA, Track trackB, List<Correlator> ignore) {
        TrackResult result = new TrackResult(trackA, trackB);
        result.setSuccess(true);
        for (Correlator c : this.correlators) {
            if (ignore.contains(c)) continue;
            CorrelatorResult cr = c.compare(trackA, trackB);
            if (!cr.getSuccess()) {
                result.setSuccess(false);
            }
            result.addCorrelatorResult(cr);
        }
        return result;
    }

    public List<Correlator> getCorrelators() {
        return this.correlators;
    }

    public void setCorrelators(List<Correlator> correlators) {
        this.correlators = correlators;
    }

    public QuickTimeComparer getComparer() {
        return this.comparer;
    }

    public void setComparer(QuickTimeComparer comparer) {
        this.comparer = comparer;
    }
}

