/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.TrackTypeResult;
import com.apple.jingle.leghorn.quicktime.compare.xml.MoviediffResultDocument;
import com.apple.jingle.leghorn.quicktime.compare.xml.TrackTypeRes;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Node;

public class ComparerResult {
    private boolean success;
    private File fileA;
    private File fileB;
    private Map<String, TrackTypeResult> trackTypeResults = new LinkedHashMap<String, TrackTypeResult>();

    public ComparerResult(boolean success, File fileA, File fileB) {
        this.success = success;
        this.fileA = fileA;
        this.fileB = fileB;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void addTrackTypeResult(TrackTypeResult result) {
        this.trackTypeResults.put(result.getName(), result);
    }

    public Map<String, TrackTypeResult> getTrackTypeResults() {
        return this.trackTypeResults;
    }

    public String toString() {
        return "success=" + this.success + "; trackTypeResults=" + this.trackTypeResults;
    }

    public Node convertToXml() {
        MoviediffResultDocument doc = MoviediffResultDocument.Factory.newInstance();
        MoviediffResultDocument.MoviediffResult res = doc.addNewMoviediffResult();
        res.setSuccess(this.success);
        res.setFileA(this.fileA.getAbsolutePath());
        res.setFileB(this.fileB.getAbsolutePath());
        for (Map.Entry<String, TrackTypeResult> entry : this.trackTypeResults.entrySet()) {
            TrackTypeRes typeRes = res.addNewTrackType();
            TrackTypeResult trackType = entry.getValue();
            trackType.convertToXml(typeRes);
        }
        XmlOptions xmlOptions = new XmlOptions();
        LinkedList errors = new LinkedList();
        xmlOptions.setErrorListener(errors);
        if (!doc.validate(xmlOptions)) {
            throw new RuntimeException("Generated description does not validate: " + errors + "\n" + doc.toString());
        }
        return doc.getDomNode();
    }
}

