/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.compare;

import com.apple.jingle.leghorn.quicktime.compare.Correlator;
import com.apple.jingle.leghorn.quicktime.compare.CorrelatorResult;
import noNamespace.Codec;
import noNamespace.SoundTrack;
import noNamespace.Track;
import noNamespace.VideoTrack;
import org.apache.log4j.Logger;

public class CodecCorrelator
extends Correlator {
    private static Logger logger = Logger.getLogger(CodecCorrelator.class);

    @Override
    public CorrelatorResult compare(Track trackA, Track trackB) {
        Codec codecA = null;
        Codec codecB = null;
        if (trackA instanceof VideoTrack) {
            codecA = ((VideoTrack)trackA).getCodec();
            codecB = ((VideoTrack)trackB).getCodec();
        } else if (trackA instanceof SoundTrack) {
            codecA = ((SoundTrack)trackA).getCodec();
            codecB = ((SoundTrack)trackB).getCodec();
        } else {
            return CorrelatorResult.success(trackA, trackB, this);
        }
        boolean result = codecA.getStringValue().equals(codecB.getStringValue());
        if (!result) {
            return CorrelatorResult.failure(trackA, trackB, this, String.format("Codec '%s' does not match '%s'", codecA.getStringValue(), codecB.getStringValue()));
        }
        return CorrelatorResult.success(trackA, trackB, this);
    }
}

