/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.itunesmetadata;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.itunesmetadata.ItunesIlistDataAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.itunesmetadata.ItunesIlistMeanAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.itunesmetadata.ItunesIlistNameAtom;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ItunesIlistMetadataItem
extends QTContainerAtom {
    protected static final List<String> REPORTABLE_TYPES = new ArrayList<String>();

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        while (movieFile.getFilePointer() < this.offset + this.size) {
            Atom atom;
            long offset = movieFile.getFilePointer();
            long size = BitstreamReader.readU32((DataInput)movieFile);
            String type = BitstreamReader.readFourCC((DataInput)movieFile);
            if (type.equals("data")) {
                atom = new ItunesIlistDataAtom();
            } else if (type.equals("mean")) {
                atom = new ItunesIlistMeanAtom();
            } else if (type.equals("name")) {
                atom = new ItunesIlistNameAtom();
            } else {
                atom = new Atom();
                movieFile.seek(offset + size);
            }
            atom.setAttributes(offset, size, type);
            atom.setParent(this);
            atom.parseAtom(ctx, quickTimeParser, movieFile);
            this.atoms.add(atom);
        }
    }

    public boolean shouldReport() {
        return REPORTABLE_TYPES.contains(this.getMeaning());
    }

    public String getMeaning() {
        String meaning = null;
        if (this.atomType.equals("----")) {
            ItunesIlistNameAtom name;
            ItunesIlistMeanAtom mean = this.findSingleChildOfType(ItunesIlistMeanAtom.class, false, false);
            if (mean != null) {
                meaning = mean.getValue();
            }
            if ((name = this.findSingleChildOfType(ItunesIlistNameAtom.class, false, false)) != null) {
                meaning = meaning + "." + name.getValue();
            }
        } else {
            meaning = this.atomType;
        }
        return meaning;
    }

    public List<ItunesIlistDataAtom> getDatas() {
        return Container.Searcher.findChildrenOfType(ItunesIlistDataAtom.class, false, this);
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] ";
    }

    static {
        REPORTABLE_TYPES.add("covr");
        REPORTABLE_TYPES.add("xid ");
        REPORTABLE_TYPES.add("\u00a9ART");
        REPORTABLE_TYPES.add("\u00a9nam");
        REPORTABLE_TYPES.add("\u00a9alb");
        REPORTABLE_TYPES.add("\u00a9cmt");
        REPORTABLE_TYPES.add("\u00a9day");
        REPORTABLE_TYPES.add("\u00a9enc");
        REPORTABLE_TYPES.add("\u00a9gen");
        REPORTABLE_TYPES.add("\u00a9st3");
        REPORTABLE_TYPES.add("\u00a9too");
        REPORTABLE_TYPES.add("\u00a9wrt");
        REPORTABLE_TYPES.add("aArt");
        REPORTABLE_TYPES.add("grup");
        REPORTABLE_TYPES.add("iTunNORM");
        REPORTABLE_TYPES.add("\u00a9arg");
        REPORTABLE_TYPES.add("\u00a9aut");
        REPORTABLE_TYPES.add("\u00a9cak");
        REPORTABLE_TYPES.add("\u00a9con");
        REPORTABLE_TYPES.add("\u00a9des");
        REPORTABLE_TYPES.add("cprt");
    }
}

