/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.itunesmetadata;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataListAtom;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class ItunesIlistDataAtom
extends UserDataListAtom {
    protected static final Map<Integer, String> DATA_TYPE_MAP = new HashMap<Integer, String>();
    protected static final Charset utf8 = Charset.forName("UTF-8");
    int reserved = 0;
    int typeSetIdentifier = 0;
    int typeCode = 0;
    int locale = 0;
    String format;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.reserved = movieFile.readShort();
        this.typeSetIdentifier = movieFile.readByte();
        this.typeCode = movieFile.readByte();
        this.locale = movieFile.readInt();
        this.format = DATA_TYPE_MAP.get(this.typeCode);
        switch (this.typeCode) {
            case 0: {
                byte[] b = new byte[(int)this.size - 16];
                movieFile.readFully(b);
                try {
                    CharBuffer cb = utf8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(b));
                    this.value = cb.toString();
                }
                catch (CharacterCodingException e) {
                    this.value = new String(Base64.encodeBase64((byte[])b, (boolean)true), utf8);
                    this.format = "0/base64";
                }
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 15: {
                byte[] b = new byte[(int)this.size - 16];
                movieFile.readFully(b);
                this.value = new String(b, DATA_TYPE_MAP.get(this.typeCode));
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                movieFile.seek(movieFile.getFilePointer() + this.size - 16L);
                this.value = "[IMAGE]";
                break;
            }
            default: {
                if (this.size < 2048L) {
                    byte[] b = new byte[(int)this.size - 16];
                    movieFile.readFully(b);
                    this.value = new String(Base64.encodeBase64((byte[])b, (boolean)true), utf8);
                    if (null == this.format) {
                        this.format = Integer.toString(this.typeCode) + "/base64";
                        break;
                    }
                    this.format = this.format + "/base64";
                    break;
                }
                movieFile.seek(movieFile.getFilePointer() + this.size - 16L);
            }
        }
    }

    public Integer getLocale() {
        return this.locale;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] " + this.value;
    }

    static {
        DATA_TYPE_MAP.put(0, "UTF-8");
        DATA_TYPE_MAP.put(1, "UTF-8");
        DATA_TYPE_MAP.put(2, "UTF-16");
        DATA_TYPE_MAP.put(6, "UTF-8");
        DATA_TYPE_MAP.put(7, "UTF-8");
        DATA_TYPE_MAP.put(8, "binarydata");
        DATA_TYPE_MAP.put(9, "UTF-8");
        DATA_TYPE_MAP.put(10, "UTF-8");
        DATA_TYPE_MAP.put(12, "GIF");
        DATA_TYPE_MAP.put(13, "JPEG");
        DATA_TYPE_MAP.put(14, "PNG");
        DATA_TYPE_MAP.put(15, "UTF-8");
        DATA_TYPE_MAP.put(16, "32-bit Integer");
    }
}

