/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Dumpsterable;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.itunesmetadata.ItunesMetaIlist;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserDataListItunesMetaAtom
extends QTContainerAtom
implements Dumpsterable {
    String value;
    protected static final Map<String, Class<? extends Atom>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends Atom>>();

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        movieFile.seek(this.offset + 12L);
        while (movieFile.getFilePointer() < this.offset + this.size - 4L) {
            long offset = movieFile.getFilePointer();
            long size = BitstreamReader.readU32((DataInput)movieFile);
            String type = BitstreamReader.readFourCC((DataInput)movieFile);
            Atom atom = null;
            if (TYPE_CLASS_MAP.containsKey(type)) {
                try {
                    atom = TYPE_CLASS_MAP.get(type).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (atom == null) {
                atom = new UserDataListAtom();
                movieFile.seek(offset + size);
            }
            atom.setAttributes(offset, size, type);
            atom.setParent(this);
            atom.parseAtom(ctx, quickTimeParser, movieFile);
            this.atoms.add(atom);
        }
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "]";
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> props = super.getProperties();
        props.add(new KeyValuePair("value", this.getValue()));
        return props;
    }

    static {
        TYPE_CLASS_MAP.put("ilst", ItunesMetaIlist.class);
    }
}

