/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Dumpsterable;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataListAtom;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.leghorn.util.UserDataUtil;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class UserDataInternationalText
extends UserDataListAtom
implements Dumpsterable {
    protected int languageCode = 0;
    protected String encoding = "UTF-8";

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.offset = movieFile.getFilePointer();
        this.size = BitstreamReader.readU16(movieFile);
        this.languageCode = BitstreamReader.readU16(movieFile);
        if (this.languageCode < 1057) {
            this.atomType = MediaHeaderAtom.macOsIntegerToLanguage.get(this.languageCode);
            this.encoding = "ISO8859_1";
        } else {
            this.atomType = this.unpack(this.languageCode);
            byte[] bom = new byte[2];
            movieFile.readFully(bom);
            this.encoding = bom[0] == 254 && bom[1] == 255 ? "UTF-16" : "UTF-8";
            movieFile.seek(movieFile.getFilePointer() - 2L);
        }
        byte[] b = new byte[(int)this.size];
        movieFile.readFully(b);
        this.value = UserDataUtil.sanitize(new String(b, this.encoding));
    }

    private String unpack(int langCode) throws UnsupportedEncodingException {
        int mask1 = 31744;
        int mask2 = 992;
        int mask3 = 31;
        int char1 = ((langCode & mask1) >>> 10) + 96;
        int char2 = ((langCode & mask2) >>> 5) + 96;
        int char3 = (langCode & mask3) + 96;
        byte[] b = new byte[]{(byte)char1, (byte)char2, (byte)char3};
        return new String(b, "ISO8859_1");
    }

    @Override
    public String toString() {
        return " " + this.atomType + ": " + this.value;
    }

    public long getSize() {
        return this.size;
    }

    public int getLanguageCode() {
        return this.languageCode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> props = super.getProperties();
        props.add(new KeyValuePair("size", this.getSize()));
        props.add(new KeyValuePair("encoding", this.getEncoding()));
        props.add(new KeyValuePair("languageCode", this.getLanguageCode()));
        props.add(new KeyValuePair("value", this.getValue()));
        return props;
    }
}

