/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.MetaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.CtryAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.LangAtom;
import com.apple.jingle.leghorn.util.UserDataUtil;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ValueAtom
extends QTAtom {
    private byte setOfTypes;
    private byte[] type;
    private int country;
    private int language;
    private String value;
    private byte[] reservedValue;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.setOfTypes = movieFile.readByte();
        this.type = new byte[3];
        movieFile.readFully(this.type);
        this.country = BitstreamReader.readU16(movieFile);
        this.language = BitstreamReader.readU16(movieFile);
        if (this.getTypeAsInt() == 0) {
            byte[] b = new byte[(int)this.size - 8];
            movieFile.readFully(b);
            this.reservedValue = b;
            this.value = "";
        } else if (this.getTypeAsInt() == 1) {
            byte[] b = new byte[(int)this.size - 8];
            movieFile.readFully(b);
            this.value = new String(b, "UTF-8");
        } else if (this.getTypeAsInt() == 2) {
            byte[] b = new byte[(int)this.size - 8];
            movieFile.readFully(b);
            this.value = new String(b, "UTF-16");
        } else if (this.getTypeAsInt() == 3) {
            byte[] b = new byte[(int)this.size - 8];
            movieFile.readFully(b);
            this.value = new String(b, "SJIS");
        } else if (this.getTypeAsInt() == 4) {
            byte[] b = new byte[(int)this.size - 8];
            movieFile.readFully(b);
            this.value = new String(b, "UTF-8");
        } else if (this.getTypeAsInt() == 5) {
            byte[] b = new byte[(int)this.size - 8];
            movieFile.readFully(b);
            this.value = new String(b, "UTF-16");
        } else if (this.getTypeAsInt() == 13 || this.getTypeAsInt() == 14 || this.getTypeAsInt() == 27) {
            this.value = "[IMAGE]";
            movieFile.skipBytes((int)this.size - 8);
        } else if (this.getTypeAsInt() == 21) {
            int numBytes = (int)this.size - 8;
            byte[] b = new byte[numBytes];
            movieFile.readFully(b);
            int intVal = 0;
            for (int i = 0; i < numBytes - 1; ++i) {
                intVal += b[i];
                intVal <<= 8;
            }
            this.value = String.valueOf(intVal += b[numBytes - 1]);
        } else if (this.getTypeAsInt() == 22) {
            int numBytes = (int)this.size - 8;
            byte[] b = new byte[numBytes];
            movieFile.readFully(b);
            long intVal = 0L;
            for (int i = 0; i < numBytes - 1; ++i) {
                intVal += (long)b[i];
                intVal <<= 8;
            }
            this.value = String.valueOf(intVal += (long)b[numBytes - 1]);
        } else {
            this.value = this.getTypeAsInt() == 23 ? String.valueOf(BitstreamReader.readBEFloat32(movieFile)) : (this.getTypeAsInt() == 24 ? String.valueOf(BitstreamReader.readBEFloat64(movieFile)) : "[UNSUPPORTED TYPE]");
        }
    }

    public int getTypeAsInt() {
        int i = this.type[0];
        i <<= 8;
        i += this.type[1];
        i <<= 8;
        return i += this.type[2];
    }

    public String getValue() throws UnsupportedEncodingException {
        return UserDataUtil.sanitize(this.value);
    }

    public byte[] getReservedValue() {
        return this.reservedValue;
    }

    public int getSetOfTypes() {
        return this.setOfTypes;
    }

    public List<String> getLocales() {
        List<? extends Atom> metasChildren;
        MetaAtom meta;
        String DEFAULT_COUNTRY = "US";
        String DEFAULT_LANGUAGE = "eng";
        List<Object> countries = new ArrayList<String>();
        List<String> languages = new ArrayList<String>();
        if (this.country == 0) {
            countries.add(DEFAULT_COUNTRY);
        } else if (this.country < 256) {
            meta = (MetaAtom)this.getParent().getParent().getParent().getParent();
            metasChildren = meta.getChildren();
            for (QTAtom qTAtom : metasChildren) {
                if (!(qTAtom instanceof CtryAtom)) continue;
                countries = ((CtryAtom)qTAtom).getCountryListAtIndex(this.country - 1);
            }
        } else {
            Locale c = new Locale(String.valueOf(this.country));
            countries.add(c.getCountry());
        }
        if (this.language == 0) {
            languages.add(DEFAULT_LANGUAGE);
        } else if (this.language < 256) {
            meta = (MetaAtom)this.getParent().getParent().getParent().getParent();
            metasChildren = meta.getChildren();
            for (QTAtom qTAtom : metasChildren) {
                if (!(qTAtom instanceof LangAtom)) continue;
                languages = ((LangAtom)qTAtom).getLanguageListAtIndex(this.language - 1);
            }
        } else {
            languages.add(this.unpack(this.language));
        }
        ArrayList<String> locales = new ArrayList<String>();
        for (int i = 0; i < languages.size(); ++i) {
            for (int j = 0; j < countries.size(); ++j) {
                locales.add((String)languages.get(i) + "-" + (String)countries.get(j));
            }
        }
        return locales;
    }

    private String unpack(int langCode) {
        int mask1 = 31744;
        int mask2 = 992;
        int mask3 = 31;
        int char1 = ((langCode & mask1) >>> 10) + 96;
        int char2 = ((langCode & mask2) >>> 5) + 96;
        int char3 = (langCode & mask3) + 96;
        byte[] b = new byte[]{(byte)char1, (byte)char2, (byte)char3};
        try {
            return new String(b, "ISO8859_1");
        }
        catch (Exception e) {
            return new String(b);
        }
    }
}

