/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms;

import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.util.UserDataUtil;
import java.io.UnsupportedEncodingException;

public class MdtaItemKey
extends Atom {
    private long keySize;
    private String namespace;
    private byte[] keyValue;
    private long keyNumber;

    MdtaItemKey(int ks, String ns, byte[] kv, int kn) {
        this.keySize = ks;
        this.namespace = ns;
        this.keyValue = kv;
        this.keyNumber = kn;
    }

    public long getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getNamespace() {
        return UserDataUtil.sanitize(this.namespace);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getKeyValueString() {
        try {
            return UserDataUtil.sanitize(new String(this.keyValue, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            return UserDataUtil.sanitize(new String(this.keyValue));
        }
    }

    public byte[] getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(byte[] keyValue) {
        this.keyValue = keyValue;
    }

    public long getKeyNumber() {
        return this.keyNumber;
    }

    @Override
    public String toString() {
        try {
            return "[" + this.atomType + "]" + " number=" + this.keyNumber + " value=" + new String(this.keyValue, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return super.toString();
        }
    }
}

