/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class LangAtom
extends QTAtom {
    private int entryCount;
    private List<List<String>> languageLists;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        movieFile.skipBytes(4);
        this.entryCount = BitstreamReader.read32(movieFile);
        this.languageLists = new ArrayList<List<String>>();
        for (int i = 0; i < this.entryCount; ++i) {
            int languageCount = BitstreamReader.read16(movieFile);
            this.languageLists.add(new ArrayList());
            for (int j = 0; j < languageCount; ++j) {
                this.languageLists.get(i).add(this.unpack(BitstreamReader.readU16(movieFile)));
            }
        }
    }

    public List<List<String>> getCountryLists() {
        return this.languageLists;
    }

    public List<String> getLanguageListAtIndex(int i) {
        return this.languageLists.get(i);
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    private String unpack(int langCode) throws UnsupportedEncodingException {
        int mask1 = 31744;
        int mask2 = 992;
        int mask3 = 31;
        int char1 = ((langCode & mask1) >>> 10) + 96;
        int char2 = ((langCode & mask2) >>> 5) + 96;
        int char3 = (langCode & mask3) + 96;
        byte[] b = new byte[]{(byte)char1, (byte)char2, (byte)char3};
        return new String(b, "ISO_8859_1");
    }
}

