/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.MdtaItemKey;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class KeysAtom
extends QTContainerAtom {
    private List<MdtaItemKey> itemKeys = new LinkedList<MdtaItemKey>();
    private int entryCount;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.entryCount = movieFile.readInt();
        for (int i = 0; i < this.entryCount; ++i) {
            int keySize = movieFile.readInt();
            String namespace = BitstreamReader.readFourCC((DataInput)movieFile);
            byte[] keyValue = new byte[keySize - 8];
            movieFile.readFully(keyValue);
            MdtaItemKey atom = new MdtaItemKey(keySize, namespace, keyValue, i + 1);
            atom.setAttributes(this.offset, this.size, "mdik");
            atom.setParent(this);
            this.atoms.add(atom);
            this.itemKeys.add(atom);
        }
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public List<MdtaItemKey> getKeys() {
        return this.itemKeys;
    }
}

