/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CtryAtom
extends QTAtom {
    private int entryCount;
    private List<List<String>> countryLists;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.entryCount = BitstreamReader.read32(movieFile);
        this.countryLists = new ArrayList<List<String>>();
        for (int i = 0; i < this.entryCount; ++i) {
            int countryCount = BitstreamReader.read16(movieFile);
            this.countryLists.add(i, new ArrayList());
            for (int j = 0; j < countryCount; ++j) {
                byte[] b = new byte[2];
                movieFile.readFully(b);
                this.countryLists.get(i).add(new String(b, "ISO8859_1"));
            }
        }
    }

    public List<List<String>> getCountryLists() {
        return this.countryLists;
    }

    public List<String> getCountryListAtIndex(int i) {
        return this.countryLists.get(i);
    }

    public int getEntryCount() {
        return this.entryCount;
    }
}

