/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Dumpsterable;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListAllFAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListCopyrightAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListInternationalTextContainer;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListItunesMetaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListNameAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListPlugAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListSelOAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListWLOCAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataTagCAtom;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserDataAtom
extends QTContainerAtom
implements Dumpsterable {
    String value;
    protected static final Map<String, Class<? extends QTContainerAtom>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends QTContainerAtom>>();

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        if (this.size == 12L) {
            movieFile.skipBytes(4);
        }
        while (movieFile.getFilePointer() < this.offset + this.size - 4L) {
            long offset = movieFile.getFilePointer();
            long size = BitstreamReader.readU32((DataInput)movieFile);
            String type = BitstreamReader.readFourCC((DataInput)movieFile);
            if (size == 0L) {
                throw new IllegalArgumentException("Size of a user data atom cannot be 0. Size of user data atom at offset: " + offset);
            }
            if (offset + size > this.offset + this.size) {
                String msg = "User data atom @ " + offset + " of " + size + " bytes (" + type + ") goes beyond file end (" + (this.offset + this.size - offset) + ")";
                ctx.addIssue(MediaValidationCode.FILE_APPEARS_CORRUPT, ctx.getMediaName(), MediaUtil.dictionary.add("errorMessage", msg).add("location", Long.toString(offset)).add("size", Long.toString(size)).add("bytesRemaining", Long.toString(this.offset + this.size - offset)));
                size = movieFile.length() - offset;
            }
            QTAtom atom = null;
            if (TYPE_CLASS_MAP.containsKey(type)) {
                try {
                    atom = TYPE_CLASS_MAP.get(type).newInstance();
                }
                catch (Exception e) {}
            } else if (type.charAt(0) == '\u00a9') {
                try {
                    atom = (QTAtom)UserDataListInternationalTextContainer.class.newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (atom == null) {
                atom = new UserDataListAtom();
                movieFile.seek(offset + size);
            }
            atom.setAttributes(offset, size, type);
            atom.setParent(this);
            atom.parseAtom(ctx, quickTimeParser, movieFile);
            this.atoms.add(atom);
        }
        try {
            if (movieFile.getFilePointer() + 4L <= movieFile.length() && movieFile.readInt() != 0) {
                movieFile.seek(movieFile.getFilePointer() - 4L);
            }
        }
        catch (EOFException eof) {
            // empty catch block
        }
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> props = super.getProperties();
        props.add(new KeyValuePair("value", this.getValue()));
        return props;
    }

    static {
        TYPE_CLASS_MAP.put("plug", UserDataListPlugAtom.class);
        TYPE_CLASS_MAP.put("AllF", UserDataListAllFAtom.class);
        TYPE_CLASS_MAP.put("name", UserDataListNameAtom.class);
        TYPE_CLASS_MAP.put("WLOC", UserDataListWLOCAtom.class);
        TYPE_CLASS_MAP.put("SelO", UserDataListSelOAtom.class);
        TYPE_CLASS_MAP.put("meta", UserDataListItunesMetaAtom.class);
        TYPE_CLASS_MAP.put("cprt", UserDataListCopyrightAtom.class);
        TYPE_CLASS_MAP.put("tagc", UserDataTagCAtom.class);
    }
}

