/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class TrackReferenceInstanceAtom
extends QTAtom {
    private List<Long> trackReferences;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.trackReferences = new LinkedList<Long>();
        int i = 2;
        while ((long)(i * 4) < this.size) {
            this.trackReferences.add(BitstreamReader.readU32((DataInput)movieFile));
            ++i;
        }
    }

    public List<Long> getTrackReferences() {
        return this.trackReferences;
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] size=" + this.size + "; trackReferences=" + this.trackReferences;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        boolean firstReference = true;
        for (Long trackNumber : this.trackReferences) {
            if (firstReference) {
                l.add(new KeyValuePair("trackReferences", trackNumber.toString()));
                firstReference = false;
                continue;
            }
            l.add(new KeyValuePair("", trackNumber.toString()));
        }
        return l;
    }
}

