/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.List;

public class TrackProductionAperatureDimensionsAtom
extends QTAtom {
    private float productionAperatureWidth;
    private float productionAperatureHeight;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.productionAperatureWidth = BitstreamReader.readFixed32(movieFile);
        this.productionAperatureHeight = BitstreamReader.readFixed32(movieFile);
    }

    @Override
    public String toString() {
        return super.toString() + ", productionAperatureWidth=" + this.productionAperatureWidth + ", productionAperatureHeight=" + this.productionAperatureHeight;
    }

    public float getProductionAperatureWidth() {
        return this.productionAperatureWidth;
    }

    public float getProductionAperatureHeight() {
        return this.productionAperatureHeight;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("productionAperatureWidth", this.productionAperatureWidth + ""));
        l.add(new KeyValuePair("productionAperatureHeight", this.productionAperatureHeight + ""));
        return l;
    }
}

