/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;

public class TrackLoadSettingsAtom
extends Atom {
    private static long kFigQTTrackLoadSettingsPreloadFlags_PreloadAlways = 1L;
    private static long kFigQTTrackLoadSettingsPreloadFlags_PreloadOnlyIfEnabled = 2L;
    long preloadStartTime;
    int preloadDuration;
    long preloadFlags;
    long defaultHints;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.preloadStartTime = BitstreamReader.read32(movieFile);
        this.preloadDuration = BitstreamReader.read32(movieFile);
        this.preloadFlags = BitstreamReader.readU32((DataInput)movieFile);
        this.defaultHints = BitstreamReader.readU32((DataInput)movieFile);
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("preloadStartTime", String.valueOf(this.preloadStartTime)));
        l.add(new KeyValuePair("preloadDuration", String.valueOf(this.preloadDuration)));
        l.add(new KeyValuePair("preloadFlags", String.valueOf(this.preloadFlags)));
        l.add(new KeyValuePair("defaultHints", String.valueOf(this.defaultHints)));
        return l;
    }

    @Override
    public String toString() {
        return super.toString() + TrackLoadSettingsAtom.propsToString(this.getProperties());
    }

    public long getPreloadStartTime() {
        return this.preloadStartTime;
    }

    public int getPreloadDuration() {
        return this.preloadDuration;
    }

    public long getPreloadFlags() {
        return this.preloadFlags;
    }

    public long getDefaultHints() {
        return this.defaultHints;
    }

    public boolean isPreloadAlways() {
        return (this.preloadFlags & kFigQTTrackLoadSettingsPreloadFlags_PreloadAlways) != 0L;
    }

    public boolean isPreloadOnlyIfEnabled() {
        return (this.preloadFlags & kFigQTTrackLoadSettingsPreloadFlags_PreloadOnlyIfEnabled) != 0L;
    }
}

