/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Matrix;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class TrackHeaderAtom
extends QTAtom {
    Date creationTime;
    Date modificationTime;
    long trackId;
    byte[] reserved = new byte[4];
    long duration;
    byte[] reserved2 = new byte[8];
    int layer;
    int alternateGroup;
    float volume;
    Matrix matrix;
    float width;
    float height;
    byte[] reserved3 = new byte[2];

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.creationTime = BitstreamReader.readDate(movieFile);
        this.modificationTime = BitstreamReader.readDate(movieFile);
        this.trackId = BitstreamReader.readU32((DataInput)movieFile);
        movieFile.readFully(this.reserved);
        this.duration = BitstreamReader.readU32((DataInput)movieFile);
        movieFile.readFully(this.reserved2);
        this.layer = BitstreamReader.read16(movieFile);
        this.alternateGroup = BitstreamReader.readU16(movieFile);
        this.volume = BitstreamReader.readFixed16(movieFile);
        movieFile.readFully(this.reserved3);
        this.matrix = new Matrix(quickTimeParser, movieFile);
        this.width = BitstreamReader.readFixed32(movieFile);
        this.height = BitstreamReader.readFixed32(movieFile);
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] trackID=" + this.trackId + "; duration=" + this.duration + "; layer=" + this.layer + "; alternateGroup=" + this.alternateGroup + "; volume=" + this.volume + "; width=" + this.width + "; height=" + this.height;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public long getDuration() {
        return this.duration;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getAlternateGroup() {
        return this.alternateGroup;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public byte[] getReserved3() {
        return this.reserved3;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("trackID", this.trackId + ""));
        return l;
    }
}

