/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.List;

public class TrackEncodedPixelsDimensionsAtom
extends QTAtom {
    private float encodedPixelsWidth;
    private float encodedPixelsHeight;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.encodedPixelsWidth = BitstreamReader.readFixed32(movieFile);
        this.encodedPixelsHeight = BitstreamReader.readFixed32(movieFile);
    }

    @Override
    public String toString() {
        return super.toString() + ", encodedPixelsWidth=" + this.encodedPixelsWidth + ", encodedPixelsHeight=" + this.encodedPixelsHeight;
    }

    public float getEncodedPixelsWidth() {
        return this.encodedPixelsWidth;
    }

    public float getEncodedPixelsHeight() {
        return this.encodedPixelsHeight;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("encodedPixelsWidth", this.encodedPixelsWidth + ""));
        l.add(new KeyValuePair("encodedPixelsHeight", this.encodedPixelsHeight + ""));
        return l;
    }
}

