/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.List;

public class TrackCleanAperatureDimensionsAtom
extends QTAtom {
    private float cleanAperatureWidth;
    private float cleanAperatureHeight;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.cleanAperatureWidth = BitstreamReader.readFixed32(movieFile);
        this.cleanAperatureHeight = BitstreamReader.readFixed32(movieFile);
    }

    @Override
    public String toString() {
        return super.toString() + ", cleanAperatureWidth=" + this.cleanAperatureWidth + ", cleanAperatureHeight=" + this.cleanAperatureHeight;
    }

    public float getCleanAperatureWidth() {
        return this.cleanAperatureWidth;
    }

    public float getCleanAperatureHeight() {
        return this.cleanAperatureHeight;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("cleanAperatureWidth", this.cleanAperatureWidth + ""));
        l.add(new KeyValuePair("cleanAperatureHeight", this.cleanAperatureHeight + ""));
        return l;
    }
}

