/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.EditAtom;
import com.apple.jingle.leghorn.quicktime.atoms.EditListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackLoadSettingsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackReferenceInstanceAtom;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;

public class TrackAtom
extends QTContainerAtom {
    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
    }

    public MediaAtom getMediaAtom() {
        return this.findSingleChildOfType(MediaAtom.class, true, true);
    }

    public TrackHeaderAtom getTrackHeaderAtom() {
        return this.findSingleChildOfType(TrackHeaderAtom.class, false, true);
    }

    public boolean isPreload() {
        TrackLoadSettingsAtom preloadAtom = this.findChild(TrackLoadSettingsAtom.class, Container.Searcher.Option.FAIL_ON_MULTIPLE);
        return preloadAtom != null && (preloadAtom.isPreloadAlways() || preloadAtom.isPreloadOnlyIfEnabled());
    }

    public boolean isChapter() {
        if (!(this.parent instanceof MovieAtom)) {
            return false;
        }
        TrackHeaderAtom header = this.findSingleChildOfType(TrackHeaderAtom.class, false, true);
        long trackID = header.getTrackId();
        MovieAtom movie = (MovieAtom)this.parent;
        for (TrackAtom tk : movie.findChildrenOfType(TrackAtom.class, false)) {
            for (TrackReferenceInstanceAtom ref : tk.findChildrenOfType(TrackReferenceInstanceAtom.class, true)) {
                if (!"chap".equals(ref.getAtomType()) || !ref.getTrackReferences().contains(trackID)) continue;
                return true;
            }
        }
        return false;
    }

    public class Cursor {
        public TrackHeaderAtom getTrackHeaderAtom() {
            return TrackAtom.this.findSingleChildOfType(TrackHeaderAtom.class, false, true);
        }

        public MediaAtom getMediaAtom() {
            return TrackAtom.this.findSingleChildOfType(MediaAtom.class, true, true);
        }

        public EditAtom getEditAtom() {
            return TrackAtom.this.findSingleChildOfType(EditAtom.class, true, false);
        }

        public EditListAtom getEditListAtom() {
            return this.getEditAtom() != null ? this.getEditAtom().findSingleChildOfType(EditListAtom.class, true, false) : null;
        }
    }
}

