/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class SyncSampleAtom
extends QTAtom {
    long numberOfEntries;
    List<Long> syncSamples;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.numberOfEntries = BitstreamReader.read32(movieFile);
        this.syncSamples = new LinkedList<Long>();
        for (long i = 0L; i < this.numberOfEntries; ++i) {
            this.syncSamples.add(Long.valueOf(BitstreamReader.read32(movieFile)));
        }
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] sync samples=" + this.syncSamples;
    }

    public long getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public List<Long> getSyncSamples() {
        return this.syncSamples;
    }
}

