/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SampleToTimeAtom
extends QTAtom {
    private long numberOfEntries;
    private long numberOfSamples = Long.MIN_VALUE;
    List<TableEntry> countToTimeTable;
    private static final Comparator<TableEntry> sampleComparator = new Comparator<TableEntry>(){

        @Override
        public int compare(TableEntry entry, TableEntry key) {
            if (key.firstSampleNumber < entry.firstSampleNumber) {
                return 1;
            }
            if (key.firstSampleNumber > entry.firstSampleNumber + entry.sampleCount) {
                return -1;
            }
            return 0;
        }
    };
    private static final Comparator<TableEntry> timeCompatator = new Comparator<TableEntry>(){

        @Override
        public int compare(TableEntry entry, TableEntry key) {
            if (key.firstSampleStartTime < entry.firstSampleStartTime) {
                return 1;
            }
            if (key.firstSampleStartTime >= entry.firstSampleStartTime + entry.entryDuration) {
                return -1;
            }
            return 0;
        }
    };

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.numberOfEntries = BitstreamReader.readU32((DataInput)movieFile);
        this.countToTimeTable = new ArrayList<TableEntry>();
        long startTime = 0L;
        long sampleNumber = 0L;
        for (long i = 0L; i < this.numberOfEntries; ++i) {
            TableEntry te = new TableEntry();
            te.sampleCount = BitstreamReader.readU32((DataInput)movieFile);
            te.sampleDuration = BitstreamReader.readU32((DataInput)movieFile);
            te.firstSampleStartTime = startTime;
            te.firstSampleNumber = sampleNumber;
            te.entryDuration = te.getSampleCount() * te.getSampleDuration();
            startTime += te.entryDuration;
            sampleNumber += te.getSampleCount();
            this.countToTimeTable.add(te);
        }
        this.numberOfSamples = sampleNumber;
    }

    @Nullable
    public TableEntry getTableEntryBySampleNumber(long sampleNumber) {
        TableEntry sampleEntry = new TableEntry();
        sampleEntry.firstSampleNumber = sampleNumber;
        sampleEntry.firstSampleStartTime = -1L;
        int idx = Collections.binarySearch(this.countToTimeTable, sampleEntry, sampleComparator);
        if (idx >= 0) {
            return this.countToTimeTable.get(idx);
        }
        return null;
    }

    public long getDurationForSample(long sample) {
        TableEntry sampleEntry = this.getTableEntryBySampleNumber(sample);
        if (null != sampleEntry) {
            return sampleEntry.getSampleDuration();
        }
        return -1L;
    }

    public long getTimeForSample(long sample) {
        TableEntry sampleEntry = this.getTableEntryBySampleNumber(sample);
        if (null != sampleEntry) {
            return sampleEntry.firstSampleStartTime + sampleEntry.getSampleDuration() * (sample - sampleEntry.firstSampleNumber);
        }
        return -1L;
    }

    @Nullable
    public TableEntry getTableEntryForTime(long time) {
        TableEntry sampleEntry = new TableEntry();
        sampleEntry.firstSampleNumber = -1L;
        sampleEntry.firstSampleStartTime = time;
        int idx = Collections.binarySearch(this.countToTimeTable, sampleEntry, timeCompatator);
        if (idx >= 0) {
            return this.countToTimeTable.get(idx);
        }
        return null;
    }

    public long getSampleForTime(long time) {
        TableEntry currentEntry = this.getTableEntryForTime(time);
        if (null != currentEntry) {
            return currentEntry.firstSampleStartTime + (long)Math.floor((float)(time - currentEntry.firstSampleStartTime) / (float)currentEntry.getSampleDuration());
        }
        return -1L;
    }

    public long getNumberOfSamples() {
        return this.numberOfSamples;
    }

    @Override
    public String toString() {
        StringBuffer tmpSB = new StringBuffer("[").append(this.atomType).append("] (");
        Iterator<TableEntry> i$ = this.countToTimeTable.iterator();
        while (i$.hasNext()) {
            TableEntry aCountToTimeTable;
            TableEntry te = aCountToTimeTable = i$.next();
            tmpSB.append(te.sampleCount).append(", ").append(te.sampleDuration).append("; ");
        }
        tmpSB.append(")");
        return tmpSB.toString();
    }

    public long getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public List<TableEntry> getCountToTimeTable() {
        return this.countToTimeTable;
    }

    public static class TableEntry
    implements Comparable<TableEntry> {
        long sampleCount;
        long sampleDuration;
        long firstSampleStartTime;
        long firstSampleNumber;
        long entryDuration;

        public TableEntry() {
        }

        public TableEntry(long sampleCount, long sampleDuration) {
            this.sampleCount = sampleCount;
            this.sampleDuration = sampleDuration;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public long getSampleDuration() {
            return this.sampleDuration;
        }

        public String toString() {
            return "sampleCount " + this.sampleCount + ", sampleDuration " + this.sampleDuration;
        }

        @Override
        public int compareTo(@Nonnull TableEntry o) {
            if (o.firstSampleNumber < this.firstSampleNumber) {
                return 1;
            }
            if (o.firstSampleNumber >= this.firstSampleNumber + this.sampleCount) {
                return -1;
            }
            return 0;
        }
    }
}

