/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.ChunkOffsetAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleDescriptionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class SampleToChunk
extends QTAtom
implements DataDumpable {
    private static final Logger logger = Logger.getLogger(SampleToChunk.class);
    long numberOfEntries;
    List<TableEntry> sampleToChunkTable;
    long[] totalSamplesAtEntry = null;
    private static final long[] NO_SAMPLES = new long[0];
    long maxChunkValue = -1L;
    Map<Long, Long> sampleCount = null;
    long mostFrequentSampleDescriptionId = 0L;
    long countOfMostFrequentSampleDescriptionId = 0L;
    static final TableEntry INVALID_ENTRY = new TableEntry(-1L, -1L, -1L);

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.write("mostFrequentSampleDescriptionId", this.mostFrequentSampleDescriptionId);
        if (this.sampleCount != null) {
            for (Map.Entry<Long, Long> entry : this.sampleCount.entrySet()) {
                dump.write("sampleCountOfId:" + entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.numberOfEntries = BitstreamReader.readU32((DataInput)movieFile);
        if (0L < this.numberOfEntries) {
            this.sampleToChunkTable = new ArrayList<TableEntry>((int)this.numberOfEntries);
            SampleDescriptionsAtom sampleDescriptionsAtom = Container.Searcher.findSingleChildOfType(SampleDescriptionsAtom.class, false, false, false, (SampleTableAtom)this.getParent());
            this.sampleCount = new HashMap<Long, Long>();
            int i = 0;
            while ((long)i < this.numberOfEntries) {
                TableEntry t = new TableEntry();
                t.firstChunk = BitstreamReader.readU32((DataInput)movieFile);
                t.samplesPerChunk = BitstreamReader.readU32((DataInput)movieFile);
                t.sampleDescriptionId = BitstreamReader.readU32((DataInput)movieFile);
                if (t.sampleDescriptionId < 1L) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Sample description with invalid sample description id " + t.sampleDescriptionId + " is referenced in the stsc atom at byte " + (movieFile.getFilePointer() - 4L) + ".");
                }
                if (null != sampleDescriptionsAtom && t.sampleDescriptionId > sampleDescriptionsAtom.numberOfEntries) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Sample description with id " + t.sampleDescriptionId + " is referenced in the stsc atom at byte " + (movieFile.getFilePointer() - 4L) + ", but it doesn't exist in the sample descriptions table.");
                }
                this.sampleToChunkTable.add(t);
                if (this.sampleCount.containsKey(t.sampleDescriptionId - 1L)) {
                    this.sampleCount.put(t.sampleDescriptionId - 1L, this.sampleCount.get(t.sampleDescriptionId - 1L) + t.samplesPerChunk);
                } else {
                    this.sampleCount.put(t.sampleDescriptionId - 1L, t.samplesPerChunk);
                }
                ++i;
            }
            long maxCount = -1L;
            for (Map.Entry<Long, Long> entry : this.sampleCount.entrySet()) {
                if (entry.getValue() < maxCount) continue;
                maxCount = entry.getValue();
                this.mostFrequentSampleDescriptionId = entry.getKey();
                this.countOfMostFrequentSampleDescriptionId = maxCount;
            }
            this.dumpData(ctx.dataDump());
        }
    }

    public TableEntry getSampleToChunk(long entry) {
        if (entry > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("This movie has too many sample to chunk entries for Leghorn");
        }
        if (null == this.sampleToChunkTable) {
            return null;
        }
        return this.sampleToChunkTable.get((int)entry);
    }

    public List<long[]> buildTestTable(long totSamples) {
        ArrayList<long[]> result = new ArrayList<long[]>();
        long first = 1L;
        long i = 0L;
        while (i + 1L < this.numberOfEntries) {
            TableEntry current = this.getSampleToChunk(i);
            TableEntry next = this.getSampleToChunk(i + 1L);
            for (long c = current.firstChunk; c < next.firstChunk; ++c) {
                int s = 0;
                while ((long)s < current.samplesPerChunk) {
                    result.add(new long[]{c, first, current.sampleDescriptionId});
                    ++s;
                }
                first += current.samplesPerChunk;
            }
            ++i;
        }
        TableEntry last = this.getSampleToChunk(this.numberOfEntries - 1L);
        long c = last.firstChunk;
        long s = 0L;
        for (long i2 = (long)result.size(); i2 < totSamples; ++i2) {
            if (s >= last.samplesPerChunk) {
                first += last.samplesPerChunk;
                s = 0L;
            }
            result.add(new long[]{++c, first, last.sampleDescriptionId});
            ++s;
        }
        return result;
    }

    TableEntry findClosestEntryForChunk(long chunk) {
        if (chunk < 1L) {
            return INVALID_ENTRY;
        }
        TableEntry e0 = null;
        if (null != this.sampleToChunkTable) {
            for (int ii = 0; ii < this.sampleToChunkTable.size() - 1; ++ii) {
                e0 = this.sampleToChunkTable.get(ii);
                TableEntry e1 = this.sampleToChunkTable.get(ii + 1);
                if (e0.firstChunk <= chunk && chunk < e1.firstChunk) break;
            }
            if (chunk >= this.sampleToChunkTable.get((int)(this.sampleToChunkTable.size() - 1)).firstChunk) {
                e0 = this.sampleToChunkTable.get(this.sampleToChunkTable.size() - 1);
            }
        }
        return e0;
    }

    public long[] getSamplesInChunk(long chunk) {
        if (chunk < 1L || null == this.sampleToChunkTable) {
            return NO_SAMPLES;
        }
        if (this.numberOfEntries == 1L) {
            TableEntry entry = this.sampleToChunkTable.get(0);
            long base = (chunk - 1L) * entry.samplesPerChunk + 1L;
            long[] res = new long[(int)entry.samplesPerChunk];
            int ii = 0;
            while ((long)ii < entry.samplesPerChunk) {
                res[ii] = base + (long)ii;
                ++ii;
            }
            return res;
        }
        return this.getSamplesInChunkCalc(chunk);
    }

    void initTotalSamplesAtEntryTable() {
        this.totalSamplesAtEntry = new long[this.sampleToChunkTable.size()];
        this.totalSamplesAtEntry[0] = 0L;
        for (int ii = 1; ii < this.sampleToChunkTable.size(); ++ii) {
            TableEntry e0 = this.sampleToChunkTable.get(ii - 1);
            TableEntry e1 = this.sampleToChunkTable.get(ii);
            this.totalSamplesAtEntry[ii] = (e1.firstChunk - e0.firstChunk) * e0.samplesPerChunk + this.totalSamplesAtEntry[ii - 1];
        }
    }

    long[] getSamplesInChunkCalc(long chunk) {
        if (this.maxChunkValue == -1L) {
            Container parentContainer = (Container)((Object)this.getParent());
            ChunkOffsetAtom stco = parentContainer.findSingleChildOfType(ChunkOffsetAtom.class, false, true);
            this.maxChunkValue = stco.getNumberOfChunks();
            if (this.maxChunkValue <= 0L) {
                return NO_SAMPLES;
            }
        }
        if (chunk > this.maxChunkValue || chunk < 1L) {
            return NO_SAMPLES;
        }
        if (this.totalSamplesAtEntry == null) {
            this.initTotalSamplesAtEntryTable();
        }
        long[] ckBounds = new long[2];
        long samplesPerChunk = -1L;
        long totalSamplesBeforeChunk = -1L;
        ckBounds[1] = -1L;
        ckBounds[0] = -1L;
        for (int ii = 0; ii < this.sampleToChunkTable.size() - 1; ++ii) {
            TableEntry e0 = this.sampleToChunkTable.get(ii);
            TableEntry e1 = this.sampleToChunkTable.get(ii + 1);
            if (e0.firstChunk > chunk || chunk >= e1.firstChunk) continue;
            ckBounds[0] = e0.firstChunk;
            ckBounds[1] = e1.firstChunk;
            samplesPerChunk = e0.samplesPerChunk;
            totalSamplesBeforeChunk = this.totalSamplesAtEntry[ii];
            break;
        }
        if (ckBounds[0] == -1L || ckBounds[1] == -1L) {
            TableEntry e0 = this.sampleToChunkTable.get(this.sampleToChunkTable.size() - 1);
            if (e0.firstChunk <= chunk && chunk <= this.maxChunkValue) {
                ckBounds[0] = e0.firstChunk;
                ckBounds[1] = this.maxChunkValue;
                samplesPerChunk = e0.samplesPerChunk;
                totalSamplesBeforeChunk = this.totalSamplesAtEntry[this.sampleToChunkTable.size() - 1];
            }
        }
        totalSamplesBeforeChunk += (chunk - ckBounds[0]) * samplesPerChunk;
        long[] res = new long[(int)samplesPerChunk];
        int ii = 0;
        while ((long)ii < samplesPerChunk) {
            res[ii] = (long)ii + totalSamplesBeforeChunk + 1L;
            ++ii;
        }
        return res;
    }

    public long[] getTestTableEntry(long sampleNumber, List<long[]> testTable) {
        return testTable.get((int)sampleNumber - 1);
    }

    @Override
    public String toString() {
        return super.toString() + "; numberOfEntries=" + this.numberOfEntries;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("numberOfEntries", this.numberOfEntries + ""));
        if (null != this.sampleToChunkTable) {
            boolean firstEntry = true;
            for (TableEntry tableEntry : this.sampleToChunkTable) {
                if (firstEntry) {
                    l.add(new KeyValuePair("sampleToChunkTable", tableEntry.firstChunk + " " + tableEntry.samplesPerChunk + " " + tableEntry.sampleDescriptionId));
                    firstEntry = false;
                    continue;
                }
                l.add(new KeyValuePair("", tableEntry.firstChunk + " " + tableEntry.samplesPerChunk + " " + tableEntry.sampleDescriptionId));
            }
        }
        return l;
    }

    public long getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public long getMostFrequentSampleDescriptionId() {
        return this.mostFrequentSampleDescriptionId;
    }

    public class ChunkCursor {
        protected long chunkNumber = 1L;
        protected long firstSample = 1L;
        protected TableEntry chunkTableEntry = null;
        protected int tableIdx = 0;

        public void gotoChunkForSample(long sampleNumber) {
            if (null != SampleToChunk.this.sampleToChunkTable) {
                if (SampleToChunk.this.numberOfEntries == 1L) {
                    long[] result = new long[]{0L, 0L};
                    this.chunkTableEntry = SampleToChunk.this.sampleToChunkTable.get(0);
                    this.calcChunkNumber(sampleNumber, this.chunkTableEntry.samplesPerChunk, result);
                    this.chunkNumber = result[0];
                    this.firstSample = result[1];
                    return;
                }
                if (sampleNumber > this.firstSample) {
                    long currentSample = this.firstSample;
                    while ((long)this.tableIdx < SampleToChunk.this.numberOfEntries) {
                        TableEntry currentEntry = SampleToChunk.this.sampleToChunkTable.get(this.tableIdx);
                        TableEntry nextEntry = null;
                        if ((long)(this.tableIdx + 1) < SampleToChunk.this.numberOfEntries) {
                            nextEntry = SampleToChunk.this.sampleToChunkTable.get(this.tableIdx + 1);
                        }
                        while (nextEntry == null || this.chunkNumber < nextEntry.firstChunk) {
                            if ((currentSample += currentEntry.samplesPerChunk) > sampleNumber) {
                                this.chunkTableEntry = currentEntry;
                                return;
                            }
                            ++this.chunkNumber;
                            this.firstSample += currentEntry.samplesPerChunk;
                        }
                        ++this.tableIdx;
                    }
                    if (this.tableIdx >= SampleToChunk.this.sampleToChunkTable.size()) {
                        this.tableIdx = SampleToChunk.this.sampleToChunkTable.size() - 1;
                    }
                } else if (sampleNumber < this.firstSample) {
                    while (this.tableIdx >= 0) {
                        TableEntry currentEntry = SampleToChunk.this.sampleToChunkTable.get(this.tableIdx);
                        while (this.chunkNumber > currentEntry.firstChunk) {
                            --this.chunkNumber;
                            this.firstSample -= currentEntry.samplesPerChunk;
                            if (sampleNumber < this.firstSample) continue;
                            this.chunkTableEntry = currentEntry;
                            return;
                        }
                        --this.tableIdx;
                    }
                    if (this.tableIdx < 0) {
                        this.tableIdx = 0;
                    }
                } else {
                    this.chunkTableEntry = SampleToChunk.this.sampleToChunkTable.get(this.tableIdx);
                }
            }
        }

        private final void calcChunkNumber(long sampleNumber, long samplesPerChunk, long[] result) {
            long chunk = 0L;
            long first = 0L;
            long rem = sampleNumber % samplesPerChunk;
            long div = sampleNumber / samplesPerChunk;
            chunk = rem == 0L ? div : div + 1L;
            first = (chunk - 1L) * samplesPerChunk + 1L;
            result[0] = chunk;
            result[1] = first;
        }

        public long getChunkNumber() {
            return this.chunkNumber;
        }

        public long getFirstSample() {
            return this.firstSample;
        }

        public long getSampleDescriptionId() {
            return null != this.chunkTableEntry ? this.chunkTableEntry.sampleDescriptionId : -1L;
        }

        public String toString() {
            return "chunkNumber=" + this.chunkNumber + "; firstSample=" + this.firstSample + "; chunkTableEntry=" + (null != this.chunkTableEntry ? this.chunkTableEntry : "<nullChunkTable>");
        }
    }

    public static class TableEntry {
        long firstChunk = 0L;
        long samplesPerChunk = 0L;
        long sampleDescriptionId = 0L;

        public TableEntry() {
        }

        public TableEntry(long firstChunk_, long samplesPerChunk_, long sampleDescriptionId_) {
            this.firstChunk = firstChunk_;
            this.samplesPerChunk = samplesPerChunk_;
            this.sampleDescriptionId = sampleDescriptionId_;
        }

        public String toString() {
            return this.firstChunk + "@" + this.samplesPerChunk + "@" + this.sampleDescriptionId;
        }
    }
}

