/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.ChunkOffset64Atom;
import com.apple.jingle.leghorn.quicktime.atoms.ChunkOffsetAtom;
import com.apple.jingle.leghorn.quicktime.atoms.CompositionOffsetTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.CompositionShiftLeastGreatestAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleDescriptionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToChunk;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;

public class SampleTableAtom
extends QTContainerAtom {
    private final String DISPLAY_TIME_OVERLAP_PREFIX_STRING = "DisplayTimeOverlaps: ";
    private final int MAX_OVERLAPS_TO_BE_REPORTED = 3;
    SeekableDataInput sdi;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.sdi = movieFile;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public boolean isHomogeneousRate() {
        Cursor cursor = new Cursor();
        SampleToTimeAtom sttsAtom = cursor.getSampleToTimeAtom();
        if (null != sttsAtom) {
            if (sttsAtom.getCountToTimeTable().isEmpty()) {
                return true;
            }
            long duration = sttsAtom.getCountToTimeTable().get(0).getSampleDuration();
            for (SampleToTimeAtom.TableEntry entry : sttsAtom.getCountToTimeTable()) {
                if (entry.getSampleDuration() == duration) continue;
                return false;
            }
        }
        return true;
    }

    private String getOverlaps(@Nonnull SampleToTimeAtom sttsAtom, @Nonnull Map<CompositionOffsetTableAtom.OffsetTableEntry, CompositionOffsetTableAtom.Overlap> overlaps) {
        if (!overlaps.isEmpty()) {
            StringBuilder msg = new StringBuilder("DisplayTimeOverlaps: ");
            int cnt = 0;
            for (Map.Entry<CompositionOffsetTableAtom.OffsetTableEntry, CompositionOffsetTableAtom.Overlap> overlap : overlaps.entrySet()) {
                if (cnt > 0) {
                    msg.append(", ");
                }
                msg.append(String.format("Sample %d and %d @ time offset %d", overlap.getValue().firstSampleIndex, overlap.getValue().secondSampleIndex, overlap.getValue().displayTime));
                ++cnt;
            }
            return msg.toString();
        }
        return null;
    }

    public boolean hasConsistentCompositionTimeline(@Nonnull LeghornValidationContext ctx) {
        Map<CompositionOffsetTableAtom.OffsetTableEntry, CompositionOffsetTableAtom.Overlap> overlaps;
        CompositionOffsetTableAtom cttsAtom;
        Cursor cursor = new Cursor();
        SampleToTimeAtom sttsAtom = cursor.getSampleToTimeAtom();
        if (null != sttsAtom && null != (cttsAtom = cursor.getCTTSAtom()) && !(overlaps = cttsAtom.getOverlappingSamples(sttsAtom, 3)).isEmpty()) {
            ctx.addCheckAlert(MediaValidationCode.MOV_IDENTICAL_DISPLAY_TIME_FOR_TWO_SAMPLES, MediaUtil.dictionary.add("message", this.getOverlaps(sttsAtom, overlaps)));
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx, SeekableDataInput movieFile) throws IOException {
        boolean validationResult = super.validate(ctx, movieFile);
        if (!this.hasConsistentCompositionTimeline(ctx)) {
            validationResult = false;
        }
        return validationResult;
    }

    public class SampleCursor {
        protected long samplePosition = 0L;
        protected long sampleLength = 0L;
        protected long sampleNumber = 0L;
        protected SampleDescription sampleDescription;
        protected SampleSizeAtom stsz;
        protected CompositionOffsetTableAtom ctts;
        protected CompositionShiftLeastGreatestAtom cslg;
        protected SampleToChunk stsc;
        protected ChunkOffsetAtom stco;
        protected SampleDescriptionsAtom stsd;
        protected SampleToChunk.ChunkCursor chunkCursor;
        protected SampleToTimeAtom stts;

        public SampleCursor() {
            this.stsz = Container.Searcher.findSingleChildOfType(SampleSizeAtom.class, true, true, true, SampleTableAtom.this);
            this.stsc = Container.Searcher.findSingleChildOfType(SampleToChunk.class, true, true, true, SampleTableAtom.this);
            this.stts = Container.Searcher.findSingleChildOfType(SampleToTimeAtom.class, true, true, true, SampleTableAtom.this);
            this.ctts = Container.Searcher.findSingleChildOfType(CompositionOffsetTableAtom.class, true, false, true, SampleTableAtom.this);
            this.cslg = Container.Searcher.findSingleChildOfType(CompositionShiftLeastGreatestAtom.class, true, false, true, SampleTableAtom.this);
            this.chunkCursor = new SampleToChunk.ChunkCursor(this.stsc);
            ChunkOffsetAtom tmpStco = Container.Searcher.findSingleChildOfType(ChunkOffsetAtom.class, true, false, true, SampleTableAtom.this);
            if (tmpStco == null) {
                tmpStco = Container.Searcher.findSingleChildOfType(ChunkOffset64Atom.class, true, true, true, SampleTableAtom.this);
            }
            this.stco = tmpStco;
            this.stsd = Container.Searcher.findSingleChildOfType(SampleDescriptionsAtom.class, true, true, true, SampleTableAtom.this);
        }

        public boolean gotoTime(long time) {
            long targetSample = this.stts.getSampleForTime(time);
            return this.gotoSample(targetSample);
        }

        public SeekableDataInput getSeekableDataInput() {
            return SampleTableAtom.this.sdi;
        }

        public boolean gotoSample(long specifiedSampleNumber) {
            if (specifiedSampleNumber > this.stsz.getSampleCount()) {
                return false;
            }
            if (specifiedSampleNumber < 1L) {
                return false;
            }
            this.chunkCursor.gotoChunkForSample(specifiedSampleNumber);
            long chunkOffset = this.stco.getChunkOffset(this.chunkCursor.getChunkNumber());
            this.sampleNumber = specifiedSampleNumber;
            this.samplePosition = chunkOffset;
            this.sampleDescription = this.stsd.get((int)this.chunkCursor.getSampleDescriptionId());
            for (long sampleIndex = this.chunkCursor.getFirstSample(); sampleIndex < specifiedSampleNumber; ++sampleIndex) {
                this.samplePosition += this.stsz.getSampleSize(sampleIndex);
            }
            this.sampleLength = this.stsz.getSampleSize(specifiedSampleNumber);
            return true;
        }

        public boolean nextSample() {
            return this.gotoSample(this.getSampleNumber() + 1L);
        }

        public boolean hasNextSample() {
            return this.sampleNumber + 1L < this.stsz.getSampleCount();
        }

        public boolean previousSample() {
            return this.gotoSample(this.getSampleNumber() - 1L);
        }

        public long getSampleNumber() {
            return this.sampleNumber;
        }

        public long getSamplePosition() {
            return this.samplePosition;
        }

        public long getSampleLength() {
            return this.sampleLength;
        }

        public SampleDescription getSampleDescription() {
            return this.sampleDescription;
        }

        public long getSampleTime() {
            return this.stts.getTimeForSample(this.sampleNumber - 1L);
        }

        public long getSampleDuration() {
            return this.stts.getDurationForSample(this.sampleNumber);
        }

        public long getChunkNumber() {
            return this.chunkCursor.getChunkNumber();
        }

        public String toString() {
            return "SampleCursor: [" + this.getSampleNumber() + "/" + this.stsz.getSampleCount() + "] " + this.getSamplePosition() + "-" + this.getSampleLength() + "b " + this.getSampleTime() + "-" + this.getSampleDuration();
        }
    }

    public class Cursor {
        public SampleToTimeAtom getSampleToTimeAtom() {
            return Container.Searcher.findSingleChildOfType(SampleToTimeAtom.class, true, false, true, SampleTableAtom.this);
        }

        public CompositionShiftLeastGreatestAtom getCSLGAtom() {
            return Container.Searcher.findSingleChildOfType(CompositionShiftLeastGreatestAtom.class, true, false, true, SampleTableAtom.this);
        }

        public CompositionOffsetTableAtom getCTTSAtom() {
            return Container.Searcher.findSingleChildOfType(CompositionOffsetTableAtom.class, true, false, true, SampleTableAtom.this);
        }

        public SampleSizeAtom getSampleSizeAtom() {
            return Container.Searcher.findSingleChildOfType(SampleSizeAtom.class, true, false, true, SampleTableAtom.this);
        }

        public SampleDescriptionsAtom getSampleDescriptions() {
            return Container.Searcher.findSingleChildOfType(SampleDescriptionsAtom.class, false, false, true, SampleTableAtom.this);
        }
    }
}

