/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SampleSizeAtom
extends QTAtom {
    long globalSampleSize;
    long numberOfEntries;
    long sampleSizeSum;
    long maxiumumSampleSize;
    List<Long> sampleSizes;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        block11: {
            block9: {
                block10: {
                    super.parseAtom(ctx, quickTimeParser, movieFile);
                    if (!this.getAtomType().equals("stsz")) break block9;
                    this.globalSampleSize = BitstreamReader.readU32((DataInput)movieFile);
                    this.numberOfEntries = BitstreamReader.readU32((DataInput)movieFile);
                    if (this.globalSampleSize == 0L) break block10;
                    this.sampleSizeSum = this.globalSampleSize * this.numberOfEntries;
                    break block11;
                }
                if (this.numberOfEntries <= 0L || this.globalSampleSize != 0L) break block11;
                this.sampleSizes = new ArrayList<Long>((int)this.numberOfEntries);
                for (long currentSampleEntry = 0L; currentSampleEntry < this.numberOfEntries; ++currentSampleEntry) {
                    long currentSampleSize = BitstreamReader.readU32((DataInput)movieFile);
                    this.sampleSizes.add(currentSampleSize);
                    if (currentSampleSize > this.maxiumumSampleSize) {
                        this.maxiumumSampleSize = currentSampleSize;
                    }
                    this.sampleSizeSum += currentSampleSize;
                }
                break block11;
            }
            movieFile.skipBytes(3);
            int fieldSize = movieFile.readUnsignedByte();
            this.numberOfEntries = BitstreamReader.readU32((DataInput)movieFile);
            this.sampleSizes = new ArrayList<Long>((int)this.numberOfEntries);
            int i = 0;
            while ((long)i < this.numberOfEntries) {
                long entry;
                if (fieldSize == 4) {
                    entry = BitstreamReader.readU8(movieFile);
                    Long upperBytes = (entry & 0xF0L) >> 4;
                    Long lowerBytes = entry & 0xFL;
                    this.sampleSizes.add(upperBytes);
                    this.sampleSizes.add(lowerBytes);
                } else if (fieldSize == 8) {
                    entry = BitstreamReader.readU8(movieFile);
                    this.sampleSizes.add(entry);
                } else if (fieldSize == 16) {
                    entry = BitstreamReader.readU16(movieFile);
                    this.sampleSizes.add(entry);
                } else {
                    throw new IllegalArgumentException("Field size of stz2 atom is " + fieldSize + " at offset " + this.offset + ", it should be 4, 8, or 16");
                }
                this.sampleSizeSum += entry;
                this.maxiumumSampleSize = this.maxiumumSampleSize > entry ? this.maxiumumSampleSize : entry;
                ++i;
            }
        }
    }

    public long getGlobalSampleSize() {
        return this.globalSampleSize;
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] sampleSize=" + this.globalSampleSize + "; numberOfEntries=" + this.numberOfEntries;
    }

    public long getSampleSizeSum() {
        return this.sampleSizeSum;
    }

    public long getMaxiumumSampleSize() {
        return this.maxiumumSampleSize;
    }

    public long getSampleSize(long sampleIndex) {
        if (sampleIndex > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("This movie has too many sample entries for Leghorn");
        }
        if (this.globalSampleSize != 0L) {
            return this.globalSampleSize;
        }
        return this.sampleSizes.get((int)(sampleIndex - 1L));
    }

    public long getSampleCount() {
        return this.numberOfEntries;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("numberOfEntries", this.numberOfEntries + ""));
        l.add(new KeyValuePair("globalSampleSize", this.globalSampleSize + ""));
        if (this.sampleSizes != null) {
            boolean firstChunk = true;
            for (Long sampleSize : this.sampleSizes) {
                if (firstChunk) {
                    l.add(new KeyValuePair("sampleSize", sampleSize.toString()));
                    firstChunk = false;
                    continue;
                }
                l.add(new KeyValuePair("", sampleSize.toString()));
            }
        }
        return l;
    }
}

