/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.AtomCursor;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.HandlerReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SoundSampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SubtitleSampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.TimecodeSampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.VTTSampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.VideoSampleDescription;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SampleDescriptionsAtom
extends QTContainerAtom {
    protected static final Map<String, Class<? extends SampleDescription>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends SampleDescription>>();
    long numberOfEntries;

    public SampleDescription get(int index) {
        return (SampleDescription)this.atoms.get(index - 1);
    }

    private static boolean isVTTTrack(MediaAtom mediaAtom) {
        SampleDescriptionsAtom stsdAtom = mediaAtom.findChild(SampleDescriptionsAtom.class, Container.Searcher.Option.RECURSE);
        if (stsdAtom == null) {
            return false;
        }
        List<SampleDescription> sampleDescriptions = stsdAtom.findChildren(SampleDescription.class, new Container.Searcher.Option[0]);
        if (sampleDescriptions.isEmpty()) {
            return false;
        }
        return "wvtt".equals(sampleDescriptions.get(0).getDataFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        long parentMaxOffset = this.getParent().getAtomOffset() + this.getParent().getAtomSize();
        this.numberOfEntries = BitstreamReader.readU32(movieFile, parentMaxOffset);
        int maxToDisplay = (int)ctx.getMediaProperties().getProperty("com.apple.jingle.leghorn.max_sample_descriptors_to_display", 10L);
        int sampleDescriptionNumber = 0;
        while ((long)sampleDescriptionNumber < this.numberOfEntries) {
            long sdOffset = movieFile.getFilePointer();
            long sdSize = BitstreamReader.readU32(movieFile, parentMaxOffset);
            String dataFormat = BitstreamReader.readFourCC(movieFile, parentMaxOffset);
            byte[] reserved = new byte[6];
            movieFile.readFully(reserved);
            int dataReference = BitstreamReader.readU16(movieFile, parentMaxOffset);
            Container mediaParent = (Container)((Object)AtomCursor.findParentOfType(this, "mdia"));
            HandlerReferenceAtom mediaHandler = (HandlerReferenceAtom)AtomCursor.findChildOfType(mediaParent, "hdlr");
            String mediaSubType = mediaHandler.getSubtype();
            if ("text".equals(mediaSubType) && ("wvtt".equals(dataFormat) || "svtt".equals(dataFormat))) {
                mediaSubType = "wvtt";
            }
            SampleDescription sampleDescription = null;
            boolean readExtensions = false;
            if (TYPE_CLASS_MAP.containsKey(mediaSubType)) {
                try {
                    sampleDescription = TYPE_CLASS_MAP.get(mediaSubType).newInstance();
                    readExtensions = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (sampleDescription == null) {
                sampleDescription = new SampleDescription();
            }
            this.atoms.add(sampleDescription);
            sampleDescription.setParent(this);
            sampleDescription.setAttributes(sdOffset, sdSize, "stsd");
            sampleDescription.setSampleDescriptionAttributes(mediaHandler.getSubtype(), dataFormat, dataReference);
            sampleDescription.parseSampleDescription(ctx, quickTimeParser, movieFile);
            while (readExtensions && movieFile.getFilePointer() < sdOffset + sdSize) {
                long sdeOffset = movieFile.getFilePointer();
                long sdeSize = BitstreamReader.readU32(movieFile, sdOffset + sdSize);
                if (sdeSize == 0L) break;
                String extensionType = BitstreamReader.readFourCC(movieFile, sdOffset + sdSize);
                SampleDescription.SampleDescriptionExtension extension = sampleDescription.createSampleDescriptionExtension(extensionType, sdeSize, sdeOffset);
                extension.parseSampleDescriptionExtension(ctx, quickTimeParser, movieFile, sdOffset + sdSize);
                sampleDescription.addSampleDescriptionExtension(extension);
                movieFile.seek(sdeOffset + sdeSize);
            }
            if (sampleDescriptionNumber < maxToDisplay) {
                try (MapDataDump childDump = ctx.dataDump().child(Integer.toString(sampleDescriptionNumber));){
                    sampleDescription.dumpData(childDump);
                    int idx = 0;
                    for (SampleDescription.SampleDescriptionExtension ex : sampleDescription.getAtoms()) {
                        try (MapDataDump exDump = childDump.child(ex.getAtomType() + "." + idx++);){
                            ex.dumpData(exDump);
                        }
                    }
                }
            }
            movieFile.seek(Math.min(sdOffset + sdSize, parentMaxOffset));
            ++sampleDescriptionNumber;
        }
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "]";
    }

    static {
        TYPE_CLASS_MAP.put("vide", VideoSampleDescription.class);
        TYPE_CLASS_MAP.put("soun", SoundSampleDescription.class);
        TYPE_CLASS_MAP.put("sbtl", SubtitleSampleDescription.class);
        TYPE_CLASS_MAP.put("tmcd", TimecodeSampleDescription.class);
        TYPE_CLASS_MAP.put("tc64", TimecodeSampleDescription.class);
        TYPE_CLASS_MAP.put("wvtt", VTTSampleDescription.class);
    }
}

